<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<meta name="Author" content="OhYeah!">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="IE=Edge">
<link rel="stylesheet" href="template.css" type="text/css">
<title>ACFinder Template</title>
<script type="text/javascript" src="template.js"></script>
<script type="text/javascript">
function opt1() {
  var cbox =
  '<li>時期／回数<select name="O1" onChange="SelCon()">'+
  '<option value="slash">標準(／結合)'+
  '<option value="break">改行分割'+
  '</select><div class="balloon">'+
  '<p>「改行分割」を選択すると、時期・回数等がセル内で改行された状態で表示されます。'+
  'Excel 等表計算ソフトに転送した場合も、セル内改行になります。</p>'+
  '<span class="arrow"><span class="inarrow"></span></span>'+
  "</div></li>\r\n";
  return cbox;
}
function opt2() {
  var cbox =
  '<li>希釈倍数等表示<select name="O2" onChange="SelBaisu()">'+
  '<option value="off">しない'+
  '<option value="on">する'+
  '</select><div class="balloon">'+
  '<p>「する」を選択すると、時期・回数に続けて「希釈倍数」あるいは「使用量」を表示します。'+
  '希釈倍数の場合はその作物・使用方法における最低濃度、使用量の場合は最多量の適用を表示し、意味が異なるのでご注意ください。</p>'+
  '<span class="arrow"><span class="inarrow"></span></span>'+
  "</div></li>\r\n";
  return cbox;
}
function SelCon() {
  var n = document.F1.O1.selectedIndex;
  var ctype = document.F1.O1.options[n].value;
  var node = document.getElementById('sql');
  if (ctype == 'slash') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/concat2\(x'1f0d'/g, "concat2('／'");
  } else {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/concat2\('／'/g, "concat2(x'1f0d'");
  }
}
function SelBaisu() {
  var n = document.F1.O2.selectedIndex;
  var ctype = document.F1.O2.options[n].value;
  var node = document.getElementById('sql');
  if (ctype == 'on') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/kaisu,'-'\)\)/, "kaisu,'-'),baisu)");
  } else {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/kaisu,'-'\),baisu\)/, "kaisu,'-'))");
  }
}
</script>
</head>
<body onload="init('',autodep(),opt1()+opt2());">
<h1>複数作物農薬一覧 (2024.10.21版)</h1>
<p>複数の作物系統を指定すると、２作物系統以上に共通して登録のある農薬を検索して、下記のような一覧表を作成します。ポジティブリスト対応のため、多品目少量生産ほ場などで作付作物に共通して登録のある農薬を調べたい時などにお使いください。</p>
<p>対象病害虫は指定した複数の作物に登録がある病害虫を全て表示します。作物系統別の対象病害虫を確認したい場合は、「複数作物農薬病害虫対応一覧」をご利用ください。</p>
<form name="F1" action="#" id="cbox"></form>
<table border="1" id="tcol">
<tr class="header">
	<th>用途</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用方法</th>
	<th>成分1</th>
	<th>系統1</th>
	<th>RAC1</th>
	<th>成分2</th>
	<th>系統2</th>
	<th>RAC2</th>
	<th>なす（露地栽培）</th>
	<th>ピーマン（露地栽培）</th>
	<th>かぼちゃ（露地栽培）</th>
	<th>オクラ</th>
	<th>対象病害虫</th>
	<th>作物数</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>ペンチオピラド水和剤</td>
	<td>アフェットフロアブル</td>
	<td>普</td>
	<td>散布</td>
	<td>ペンチオピラド</td>
	<td>チオフェン系</td>
	<td>F:7</td>
	<td></td>
	<td></td>
	<td></td>
	<td>収穫前日まで／3回以内</td>
	<td>収穫前日まで／3回以内</td>
	<td>収穫前日まで／3回以内</td>
	<td>収穫前日まで／3回以内</td>
	<td>うどんこ病, すすかび病, 灰色かび病, 菌核病, 黒枯病</td>
	<td>4</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>2008.07.23</td>
</tr>
<tr class="even">
	<td>殺菌剤</td>
	<td>ピラクロストロビン・ボスカリド水和剤</td>
	<td>シグナムWDG</td>
	<td>普</td>
	<td>散布</td>
	<td>ピラクロストロビン</td>
	<td>ストロビルリン</td>
	<td>F:11</td>
	<td>ボスカリド</td>
	<td>カルボキシアミド</td>
	<td>F:7</td>
	<td>収穫前日まで／3回以内</td>
	<td>収穫前日まで／2回以内</td>
	<td>収穫前日まで／3回以内</td>
	<td></td>
	<td>うどんこ病, すすかび病, 灰色かび病, 菌核病, 炭疽病, 黒枯病</td>
	<td>3</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>0</td>
	<td>2008.11.19</td>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>トリフルミゾール水和剤</td>
	<td>トリフミン水和剤</td>
	<td>普</td>
	<td>散布</td>
	<td>トリフルミゾール</td>
	<td>EBI</td>
	<td>F:3</td>
	<td></td>
	<td></td>
	<td></td>
	<td>収穫前日まで／5回以内</td>
	<td>収穫前日まで／5回以内</td>
	<td>収穫前日まで／5回以内</td>
	<td>収穫前日まで／3回以内</td>
	<td>うどんこ病, すすかび病, 黒斑病</td>
	<td>4</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1986.04.14</td>
</tr>
</table>
<table border="1" id="trow">
<tr class="header">
	<th>用途</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用方法</th>
	<th>有効成分</th>
	<th>系統名</th>
	<th>RACコード</th>
	<th>なす（露地栽培）</th>
	<th>ピーマン（露地栽培）</th>
	<th>かぼちゃ（露地栽培）</th>
	<th>オクラ</th>
	<th>対象病害虫</th>
	<th>作物数</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>ペンチオピラド水和剤</td>
	<td>アフェットフロアブル</td>
	<td>普</td>
	<td>散布</td>
	<td>ペンチオピラド</td>
	<td>チオフェン系</td>
	<td>F:7</td>
	<td>収穫前日まで／3回以内</td>
	<td>収穫前日まで／3回以内</td>
	<td>収穫前日まで／3回以内</td>
	<td>収穫前日まで／3回以内</td>
	<td>うどんこ病, すすかび病, 灰色かび病, 菌核病, 黒枯病</td>
	<td>4</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>2008.07.23</td>
</tr>
<tr class="even">
	<td>殺菌剤</td>
	<td>ピラクロストロビン・ボスカリド水和剤</td>
	<td>シグナムWDG</td>
	<td>普</td>
	<td>散布</td>
	<td>ピラクロストロビン<br>ボスカリド</td>
	<td>ストロビルリン<br>カルボキシアミド</td>
	<td>F:11<br>F:7</td>
	<td>収穫前日まで／3回以内</td>
	<td>収穫前日まで／2回以内</td>
	<td>収穫前日まで／3回以内</td>
	<td></td>
	<td>うどんこ病, すすかび病, 灰色かび病, 菌核病, 炭疽病, 黒枯病</td>
	<td>3</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>0</td>
	<td>2008.11.19</td>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>トリフルミゾール水和剤</td>
	<td>トリフミン水和剤</td>
	<td>普</td>
	<td>散布</td>
	<td>トリフルミゾール</td>
	<td>EBI</td>
	<td>F:3</td>
	<td>収穫前日まで／5回以内</td>
	<td>収穫前日まで／5回以内</td>
	<td>収穫前日まで／5回以内</td>
	<td>収穫前日まで／3回以内</td>
	<td>うどんこ病, すすかび病, 黒斑病</td>
	<td>4</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1986.04.14</td>
</tr>
</table>
<table border="1" id="tclb">
<tr class="header">
	<th>用途</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用方法</th>
	<th>有効成分</th>
	<th>系統名</th>
	<th>RACコード</th>
	<th>なす（露地栽培）</th>
	<th>ピーマン（露地栽培）</th>
	<th>かぼちゃ（露地栽培）</th>
	<th>オクラ</th>
	<th>対象病害虫</th>
	<th>作物数</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>ペンチオピラド水和剤</td>
	<td>アフェットフロアブル</td>
	<td>普</td>
	<td>散布</td>
	<td>ペンチオピラド</td>
	<td>チオフェン系</td>
	<td>F:7</td>
	<td>収穫前日まで／3回以内</td>
	<td>収穫前日まで／3回以内</td>
	<td>収穫前日まで／3回以内</td>
	<td>収穫前日まで／3回以内</td>
	<td>うどんこ病, すすかび病, 灰色かび病, 菌核病, 黒枯病</td>
	<td>4</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>2008.07.23</td>
</tr>
<tr class="even">
	<td>殺菌剤</td>
	<td>ピラクロストロビン・ボスカリド水和剤</td>
	<td>シグナムWDG</td>
	<td>普</td>
	<td>散布</td>
	<td>1 ピラクロストロビン<br>2 ボスカリド</td>
	<td>1 ストロビルリン<br>2 カルボキシアミド</td>
	<td>1 F:11<br>2 F:7</td>
	<td>収穫前日まで／3回以内</td>
	<td>収穫前日まで／2回以内</td>
	<td>収穫前日まで／3回以内</td>
	<td></td>
	<td>うどんこ病, すすかび病, 灰色かび病, 菌核病, 炭疽病, 黒枯病</td>
	<td>3</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>0</td>
	<td>2008.11.19</td>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>トリフルミゾール水和剤</td>
	<td>トリフミン水和剤</td>
	<td>普</td>
	<td>散布</td>
	<td>トリフルミゾール</td>
	<td>EBI</td>
	<td>F:3</td>
	<td>収穫前日まで／5回以内</td>
	<td>収穫前日まで／5回以内</td>
	<td>収穫前日まで／5回以内</td>
	<td>収穫前日まで／3回以内</td>
	<td>うどんこ病, すすかび病, 黒斑病</td>
	<td>4</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1986.04.14</td>
</tr>
</table>
<h2>設定項目</h2>
<dl>
<dt>■ 作物名</dt>
<dd>
<p>検索対象とする作物系統を<em>２系統以上</em>指定します。<em>[必須]</em></p>
<p>「作物群一括検索」で「する」を選択した場合、作物名に「'きゅうり'」だけを指定しても「きゅうり」以外に上位作物群の「うり類(未成熟),うり科野菜類,うり類,野菜類」のほか、
下位作物群として「きゅうり(施設栽培),きゅうり(露地栽培(移植栽培)),きゅうり(露地栽培(直播栽培)),野菜類(施設栽培),野菜類(露地栽培)」のような各作物群の詳細作物名も含めて検索します。
作物名に「'きゅうり(施設栽培)'」を指定した場合は、上位作物群の「きゅうり,うり類(未成熟),うり科野菜類,うり類,野菜類」(ただし「(露地栽培)」のような相反する詳細作物名は除く)を検索します。</p>
<p>登録農薬が多い作物で大作物群などの上位作物群まで含めて検索したくない場合は、「作物群一括検索」で「しない」を選択し、
「'きゅうり(施設野菜),きゅうり'」あるいは「'きゅうり,うり類(未成熟),うり科野菜類,うり類'」などのように遡る作物群を限定します。
作物群一括検索「しない」でも、「'きゅうり'」を指定した場合、下位作物群である「きゅうり(施設栽培),きゅうり(露地栽培(移植栽培)),きゅうり(露地栽培(直播栽培))」も含めて検索します。</p>
</dd>
<dt>□ 用途</dt>
<dd>
<p>検索対象とする用途を複数選択できます。無指定の場合は、全ての用途を検索します。</p>
<p>初期設定では「殺虫剤, 殺菌剤, 殺虫殺菌剤」になっています。「殺菌剤」あるいは「殺虫剤」のみの表を作成したい場合は、「殺菌剤」あるいは「殺虫剤」だけにしてください。</p>
</dd>
<dt>□ 剤型</dt>
<dd>
<p>検索対象とする剤型を複数選択できます。無指定の場合は、全ての剤型を検索します。</p>
<p>噴霧剤だけを検索したい場合は、「噴霧剤.arg」を読み込んでください。</p>
</dd>
<dt>□ その他</dt>
<dd>
<p>上記以外の項目を検索条件にしたい場合、条件式を直接記述します。使用時期・使用方法などを限定したい場合や、特定の通称のみを表示したい場合などに使用します。</p>
<p>収穫期に使用可能な散布剤だけを検索したい場合は、「収穫期散布剤.arg」を読み込んでください。</p>
</dd>
</dl>
<h2>設定例</h2>
<div>
<p><span class="button">設定読込</span>ボタンをクリックして、下記ファイルを選択してください。</p>
<pre>
夏野菜殺虫剤.arg
夏野菜収穫期希釈散布殺菌剤.arg
</pre>
</div>
<h2>ヒント</h2>
<div>
<p>たとえば、「なす」と「なす（露地栽培）」をひとつにまとめたい場合は、作物名テキストボックス上でこれらをシングルクォート(')で囲んでください。項目名は、最初の作物名になります（この例では「なす」）。</p>
</div>
<dl>
<dt>修正前</dt>
<dd><div class="example">
なす,なす（露地栽培）,オクラ
</div></dd>
<dt>修正後</dt>
<dd><div class="example">
<strong>'</strong>なす,なす（露地栽培）<strong>'</strong>,オクラ
</div></dd>
</dl>
<h2>定義</h2>
<dl>
<dt>テンプレート定義</dt>
<dd><xmp id="sql">
#template {
--/d
drop table if exists tTpl;
create temp table tTpl as
select distinct
  yoto,shurui,tsusho,dokusei,hoho,
  seibun1,seibun2,seibun3,seibun4,seibun5,
  keito1,keito2,keito3,keito4,keito5,
  null as rac1, null as rac2, null as rac3, null as rac4, null as rac5,
  max(case when '、'||concat('、', sakumotsu, shozoku)||'、' regexp [~sakumotsu~] and nozoku not regexp [~sakumotsu~] or fukumu regexp [~sakumotsu~] then concat2('／',ifnullstr(jiki,'-'),ifnullstr(kaisu,'-')) else '' end) as [#sakumotsu#],
  concat(', ', case when 
    (sakumotsu regexp '(^|、|\()('||[/sakumotsu/]||')(\(|\)|、|等|$)' and sakumotsu not regexp [!sakumotsu!]) or
  0 then byochu else '' end) as 対象病害虫,
  kongo,zaikei,koka,
  zenkoku as ryutsu,
  zenkoku,
  torokubi
from m_tekiyo left join m_kihon using(bango) left join seizai using(bango) left join idshurui using(bango) left join ryutsu using(idshurui) left join m_sakumotsu using(sakumotsu) left join sakuhojo using(idsaku)
where
  --ryakusho <> 'ホクサン株式会社' and
  --ryakusho <> '琉球産経株式会社' and
  --yoto in (<yoto>) and
  --zaikei in (<zaikei>) and
  --<sonota> and
  sakumotsu in (select sakumotsu from m_sakumotsu left join sakuhojo using(idsaku) where 
    ('、'||concat('、', sakumotsu, shozoku)||'、' regexp [~sakumotsu~] and nozoku not regexp [~sakumotsu~] or fukumu regexp [~sakumotsu~]) or
    0
  )
group by bango, hoho;
update tTpl set seibun1 = ifnullstr((select kanryaku from tseibun where ippanmei = seibun1), seibun1) where seibun1 is not null;
update tTpl set seibun2 = ifnullstr((select kanryaku from tseibun where ippanmei = seibun2), seibun2) where seibun2 is not null;
update tTpl set seibun3 = ifnullstr((select kanryaku from tseibun where ippanmei = seibun3), seibun3) where seibun3 is not null;
update tTpl set seibun4 = ifnullstr((select kanryaku from tseibun where ippanmei = seibun4), seibun4) where seibun4 is not null;
update tTpl set seibun5 = ifnullstr((select kanryaku from tseibun where ippanmei = seibun5), seibun5) where seibun5 is not null;
update tTpl set rac1 = (select mid from rac where ippanmei = seibun1) where seibun1 is not null;
update tTpl set rac2 = (select mid from rac where ippanmei = seibun2) where seibun2 is not null;
update tTpl set rac3 = (select mid from rac where ippanmei = seibun3) where seibun3 is not null;
update tTpl set rac4 = (select mid from rac where ippanmei = seibun4) where seibun4 is not null;
update tTpl set rac5 = (select mid from rac where ippanmei = seibun5) where seibun5 is not null;
select
  yoto,shurui,tsusho,dokusei,hoho,
  seibun1,keito1,rac1,
  seibun2,keito2,rac2,
  seibun3,keito3,rac3,
  seibun4,keito4,rac4,
  seibun5,keito5,rac5,
  --concat2(x'1d0d', seibun1, seibun2, seibun3, seibun4, seibun5) as ippanmei,
  --concat2(x'1d0d', keito1, keito2, keito3, keito4, keito5) as keito,
  --concat2(x'1d0d', rac1, rac2, rac3, rac4, rac5) as mid,
  --concat2(x'1f0d', if(seibun2 is null, '', '1 ')||seibun1, '2 '||seibun2, '3 '||seibun3, '4 '||seibun4, '5 '||seibun5) as ippanmei,
  --concat2(x'1f0d', if(keito2 is null, '', '1 ')||keito1, '2 '||keito2, '3 '||keito3, '4 '||keito4, '5 '||keito5) as keito,
  --concat2(x'1f0d', if(rac2 is null, '', '1 ')||rac1, '2 '||rac2, '3 '||rac3, '4 '||rac4, '5 '||rac5) as mid,
  [#sakumotsu#],
  対象病害虫,
  (
    if([#sakumotsu#] = '', 0, 1) + 
  0) as 作物数,
  kongo,zaikei,koka,
  if(zenkoku, ryutsu, ifnull(zenkoku, -1) - 1) as 流通,
  min(torokubi) as torokubi
from tTpl
where 作物数 > 1
group by tsusho, dokusei, hoho
order by yoto, tsusho;
}
</xmp></dd>
<dt>デフォルト定義</dt>
<dd><pre>
#default {
  yoto = "殺虫剤, 殺菌剤, 殺虫殺菌剤"
}
</pre></dd>
</dl>
</body>
</html>
