<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<meta name="Author" content="OhYeah!">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="IE=Edge">
<link rel="stylesheet" href="template.css" type="text/css">
<title>ACFinder Template</title>
<script type="text/javascript" src="template.js"></script>
<script type="text/javascript">
function opt1() {
  var cbox =
  '<li>病害虫区分<select name="O1" onChange="SelCat()">'+
  '<option value="none">指定なし'+
  '<option value="fungi">病害'+
  '<option value="insect">害虫'+
  '<option value="pest">病害虫'+
  '</select><div class="balloon">'+
  '<p>病害のみを対象とした一覧表を作成したい場合は「病害」、害虫のみは「害虫」、病害・害虫混合は「病害虫」を選択してください。</p>'+
  '<span class="arrow"><span class="inarrow"></span></span>'+
  "</div></li>\r\n";
  return cbox;
}
function SelCat() {
  var n = document.F1.O1.selectedIndex;
  var ctyp = document.F1.O1.options[n].value;
  var node = document.getElementById('sql');
  if (ctyp == 'none') {
     node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/  cid in/, '  --cid in');
  } else {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/--cid in/, 'cid in');
    if (ctyp == 'fungi') {
      node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/cid in \(.*?\)/, 'cid in (1)');
    } else if (ctyp == 'insect') {
      node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/cid in \(.*?\)/, 'cid in (2)');
    } else {
      node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/cid in \(.*?\)/, 'cid in (1,2)');
    }
  }
}
</script>
</head>
<body onload="init('',autodep(),opt1());">
<h1>特定作物農薬病害虫対応一覧 (2024.10.29版)</h1>
<p>特定の作物系統と病害虫を指定すると、その作物系統に登録のある農薬を検索して、下記のような農薬／病害虫対応一覧表を作成します。農薬の病害虫対応表を作成したい時にお使いください。</p>
<form name="F1" action="#" id="cbox"></form>
<table border="1" id="tcol">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>使用方法</th>
	<th>散布液量</th>
	<th>成分1</th>
	<th>回数1</th>
	<th>系統1</th>
	<th>RAC1</th>
	<th>成分2</th>
	<th>回数2</th>
	<th>系統2</th>
	<th>RAC2</th>
	<th>アブラムシ類</th>
	<th>コナジラミ類</th>
	<th>アザミウマ類</th>
	<th>ハダニ類</th>
	<th>その他</th>
	<th>病害虫数</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺虫剤</td>
	<td>きゅうり</td>
	<td>エマメクチン安息香酸塩・ルフェヌロン水和剤</td>
	<td>アファームエクセラ顆粒水和剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>2回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>エマメクチン安息香酸塩</td>
	<td>2回以内</td>
	<td>マクロライド</td>
	<td>I:6</td>
	<td>ルフェヌロン</td>
	<td>3回以内</td>
	<td>ベンゾイル尿素(IGR脱皮阻害)</td>
	<td>I:15</td>
	<td></td>
	<td></td>
	<td>1500倍 ミナミキイロ</td>
	<td></td>
	<td>ウリノメイガ 1500倍</td>
	<td>2</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺虫</td>
	<td>1</td>
	<td>2006.11.29</td>
</tr>
<tr class="even">
	<td>殺虫剤</td>
	<td>きゅうり</td>
	<td>クロルフェナピル水和剤</td>
	<td>コテツフロアブル</td>
	<td>劇</td>
	<td>収穫前日まで</td>
	<td>3回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>クロルフェナピル</td>
	<td>3回以内</td>
	<td>ピロール</td>
	<td>I:13</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>2000倍 ミカンキイロ, 2000倍 ミナミキイロ</td>
	<td>2000倍</td>
	<td>ウリノメイガ 2000倍, ウリハムシ 2000倍</td>
	<td>5</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺虫</td>
	<td>1</td>
	<td>1996.04.25</td>
</tr>
<tr class="odd">
	<td>殺虫剤</td>
	<td>きゅうり</td>
	<td>スピロテトラマト水和剤</td>
	<td>モベントフロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>3回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>スピロテトラマト</td>
	<td>3回以内(灌注は1回以内)</td>
	<td>環状ケトエノール</td>
	<td>I:23</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>2000倍</td>
	<td>2000倍</td>
	<td>2000倍</td>
	<td>2000倍</td>
	<td></td>
	<td>4</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺虫・殺ダニ</td>
	<td>-2</td>
	<td>2012.12.28</td>
</tr>
</table>
<table border="1" id="trow">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>使用方法</th>
	<th>散布液量</th>
	<th>有効成分</th>
	<th>使用回数</th>
	<th>系統名</th>
	<th>RACコード</th>
	<th>アブラムシ類</th>
	<th>コナジラミ類</th>
	<th>アザミウマ類</th>
	<th>ハダニ類</th>
	<th>その他</th>
	<th>病害虫数</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺虫剤</td>
	<td>きゅうり</td>
	<td>エマメクチン安息香酸塩・ルフェヌロン水和剤</td>
	<td>アファームエクセラ顆粒水和剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>2回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>エマメクチン安息香酸塩<br>ルフェヌロン</td>
	<td>2回以内<br>3回以内</td>
	<td>マクロライド<br>ベンゾイル尿素(IGR脱皮阻害)</td>
	<td>I:6<br>I:15</td>
	<td></td>
	<td></td>
	<td>1500倍 ミナミキイロ</td>
	<td></td>
	<td>ウリノメイガ 1500倍</td>
	<td>2</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺虫</td>
	<td>1</td>
	<td>2006.11.29</td>
</tr>
<tr class="even">
	<td>殺虫剤</td>
	<td>きゅうり</td>
	<td>クロルフェナピル水和剤</td>
	<td>コテツフロアブル</td>
	<td>劇</td>
	<td>収穫前日まで</td>
	<td>3回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>クロルフェナピル</td>
	<td>3回以内</td>
	<td>ピロール</td>
	<td>I:13</td>
	<td></td>
	<td></td>
	<td>2000倍 ミカンキイロ, 2000倍 ミナミキイロ</td>
	<td>2000倍</td>
	<td>ウリノメイガ 2000倍, ウリハムシ 2000倍</td>
	<td>5</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺虫</td>
	<td>1</td>
	<td>1996.04.25</td>
</tr>
<tr class="odd">
	<td>殺虫剤</td>
	<td>きゅうり</td>
	<td>スピロテトラマト水和剤</td>
	<td>モベントフロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>3回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>スピロテトラマト</td>
	<td>3回以内(灌注は1回以内)</td>
	<td>環状ケトエノール</td>
	<td>I:23</td>
	<td>2000倍</td>
	<td>2000倍</td>
	<td>2000倍</td>
	<td>2000倍</td>
	<td></td>
	<td>4</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺虫・殺ダニ</td>
	<td>-2</td>
	<td>2012.12.28</td>
</tr>
</table>
<table border="1" id="tclb">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>使用方法</th>
	<th>散布液量</th>
	<th>有効成分</th>
	<th>使用回数</th>
	<th>系統名</th>
	<th>RACコード</th>
	<th>アブラムシ類</th>
	<th>コナジラミ類</th>
	<th>アザミウマ類</th>
	<th>ハダニ類</th>
	<th>その他</th>
	<th>病害虫数</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺虫剤</td>
	<td>きゅうり</td>
	<td>エマメクチン安息香酸塩・ルフェヌロン水和剤</td>
	<td>アファームエクセラ顆粒水和剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>2回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>1 エマメクチン安息香酸塩<br>2 ルフェヌロン</td>
	<td>1 2回以内<br>2 3回以内</td>
	<td>1 マクロライド<br>2 ベンゾイル尿素(IGR脱皮阻害)</td>
	<td>1 I:6<br>2 I:15</td>
	<td></td>
	<td></td>
	<td>1500倍 ミナミキイロ</td>
	<td></td>
	<td>ウリノメイガ 1500倍</td>
	<td>2</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺虫</td>
	<td>1</td>
	<td>2006.11.29</td>
</tr>
<tr class="even">
	<td>殺虫剤</td>
	<td>きゅうり</td>
	<td>クロルフェナピル水和剤</td>
	<td>コテツフロアブル</td>
	<td>劇</td>
	<td>収穫前日まで</td>
	<td>3回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>クロルフェナピル</td>
	<td>3回以内</td>
	<td>ピロール</td>
	<td>I:13</td>
	<td></td>
	<td></td>
	<td>2000倍 ミカンキイロ, 2000倍 ミナミキイロ</td>
	<td>2000倍</td>
	<td>ウリノメイガ 2000倍, ウリハムシ 2000倍</td>
	<td>5</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺虫</td>
	<td>1</td>
	<td>1996.04.25</td>
</tr>
<tr class="odd">
	<td>殺虫剤</td>
	<td>きゅうり</td>
	<td>スピロテトラマト水和剤</td>
	<td>モベントフロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>3回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>スピロテトラマト</td>
	<td>3回以内(灌注は1回以内)</td>
	<td>環状ケトエノール</td>
	<td>I:23</td>
	<td>2000倍</td>
	<td>2000倍</td>
	<td>2000倍</td>
	<td>2000倍</td>
	<td></td>
	<td>4</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺虫・殺ダニ</td>
	<td>-2</td>
	<td>2012.12.28</td>
</tr>
</table>
<h2>設定項目</h2>
<dl>
<dt>■ 作物名</dt>
<dd>
<p>検索対象とする作物系統を１系統のみ指定できます。<em>[必須]</em></p>
<p>「作物群一括検索」で「する」を選択した場合、作物名に「'きゅうり'」だけを指定しても「きゅうり」以外に上位作物群の「うり類(未成熟),うり科野菜類,うり類,野菜類」のほか、
下位作物群である「きゅうり(施設栽培),きゅうり(露地栽培(移植栽培)),きゅうり(露地栽培(直播栽培))」も含めて検索します。
作物名に「'きゅうり(施設栽培)'」を指定した場合は、上位作物群の「きゅうり,うり類(未成熟),うり科野菜類,うり類,野菜類」(ただし「野菜類(露地栽培)」は除く)を検索します。</p>
<p>登録農薬が多い作物で大作物群などの上位作物群まで含めて検索したくない場合は、「作物群一括検索」で「しない」を選択し、
「'きゅうり(施設野菜),きゅうり'」あるいは「'きゅうり,うり類(未成熟),うり科野菜類,うり類'」などのように遡る作物群を限定します。
作物群一括検索「しない」でも、「'きゅうり'」を指定した場合、下位作物群である「きゅうり(施設栽培),きゅうり(露地栽培(移植栽培)),きゅうり(露地栽培(直播栽培))」も含めて検索します。</p>
</dd>
<dt>■ 病害虫</dt>
<dd>
<p>検索対象とする病害虫名を複数指定します。<em>[必須]</em>
<p>一覧にしたい主な病害虫を指定してください。ここで指定しなかった病害虫は「その他」に列挙されますので、全てを指定する必要はありません。
検索結果は病害虫名テキストボックスに記入された左側から順番に表示されますので、病害虫名の選択順に注意してください。</p>
<p>「ウリハムシ成虫」「ウリハムシ幼虫」のように病害虫名の後に文字が追加されている場合は、「ウリハムシ」だけを指定すれば全て検索対象となり、検索結果のウリハムシの列に「成虫」「幼虫」などの注釈が表示されます。</p>
<p>「ワタアブラムシ」のように病害虫名の前に文字が追加されている場合は、アブラムシ類とワタアブラムシの両方を指定する必要があります。
この場合、複数の病害虫名をシングルクォート(')で括ると、ひとつの枠に検索結果が表示されます。たとえば、下記のように括るとアブラムシ類の列にワタアブラムシ、ハモグリバエ類の列にトマトハモグリバエ、センチュウ類の列にネコブセンチュウの農薬の希釈倍数・使用量が表示され、それぞれ「ワタ」「トマト」「ネコブ」という注釈が付加されます。</p>
<div class="example">
<strong>'</strong>アブラムシ類,ワタアブラムシ<strong>'</strong>,<strong>'</strong>ハモグリバエ類,トマトハモグリバエ<strong>'</strong>,<strong>'</strong>センチュウ類,ネコブセンチュウ<strong>'</strong>
</div>
</dd>
<dt>□ 用途</dt>
<dd>
<p>検索対象とする用途を複数選択できますが、殺虫剤一覧、殺菌剤一覧、殺虫剤・殺菌剤混合一覧を作成する場合は、テンプレート処理内容の上部にある「病害虫区分」ドロップダウンリストで選択してください。</p>
<p>除草剤一覧を作成する場合は、「病害虫区分」で「指定なし」を選択し、「用途」で「除草剤」を選択してください。</p>
</dd>
<dt>□ 剤型</dt>
<dd>
<p>検索対象とする剤型を複数選択できます。無指定の場合は、全ての剤型を検索します。</p>
<p>噴霧剤だけを検索したい場合は、「噴霧剤.arg」を読み込んでください。</p>
</dd>
<dt>□ その他</dt>
<dd>
<p>上記以外の項目を検索条件にしたい場合、条件式を直接記述します。使用時期・使用方法などを限定したい場合や、特定の通称のみを表示したい場合などに使用します。</p>
<p>収穫期に使用可能な散布剤だけを検索したい場合は、「収穫期散布剤.arg」を読み込んでください。</p>
</dd>
</dl>
<h2>設定例</h2>
<div>
<p><span class="button">設定読込</span>ボタンをクリックして、下記ファイルを選択してください。</p>
<p>両設定例とも、「病害虫区分」ドロップダウンリストを選択した際に実行すべき処理内容を「その他」に直接記載しているため、「病害虫区分」は「指定なし」で実行してください。</p>
<pre>
施設きゅうり殺虫剤.arg
施設きゅうり収穫期希釈散布殺菌剤.arg
</pre>
</div>
<h2>定義</h2>
<dl>
<dt>テンプレート定義</dt>
<dd><xmp id="sql">
#template {
--/d
drop table if exists tTpl;
create temp table tTpl as
select distinct
  bango,yoto,sakumotsu,shurui,tsusho,dokusei,jiki,kaisu,hoho,
  byochu,baisu,ekiryo,basho,jikan,ondo,dojo,chitai,tekiyaku,
  seibun1,seibun2,seibun3,seibun4,seibun5,
  kaisu1,kaisu2,kaisu3,kaisu4,kaisu5,
  keito1,keito2,keito3,keito4,keito5,
  null as rac1, null as rac2, null as rac3, null as rac4, null as rac5,
  kongo,zaikei,koka,
  zenkoku as ryutsu,
  zenkoku,torokubi
from m_tekiyo left join m_kihon using(bango) left join seizai using(bango) left join idshurui using(bango) left join ryutsu using(idshurui) left join byochu using(byochu)
where
  --ryakusho <> 'ホクサン株式会社' and
  --ryakusho <> '琉球産経株式会社' and
  --cid in (1,2) and
  --yoto in (<yoto>) and
  --zaikei in (<zaikei>) and
  --<sonota> and
  (shurui <> '展着剤' and concat('、', hoho, basho) not regexp '倉庫|貯蔵|気密|天幕|サイロ') and
  sakumotsu in (select sakumotsu from m_sakumotsu left join sakuhojo using(idsaku) where 
    '、'||concat('、', sakumotsu, shozoku)||'、' regexp <~sakumotsu~> and nozoku not regexp <~sakumotsu~> or fukumu regexp <~sakumotsu~>
  );
update tTpl set kaisu1 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun1), kaisu1) where kaisu1 is not null;
update tTpl set kaisu2 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun2), kaisu2) where kaisu2 is not null;
update tTpl set kaisu3 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun3), kaisu3) where kaisu3 is not null;
update tTpl set kaisu4 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun4), kaisu4) where kaisu4 is not null;
update tTpl set kaisu5 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun5), kaisu5) where kaisu5 is not null;
update tTpl set rac1 = (select mid from rac where ippanmei = seibun1) where seibun1 is not null;
update tTpl set rac2 = (select mid from rac where ippanmei = seibun2) where seibun2 is not null;
update tTpl set rac3 = (select mid from rac where ippanmei = seibun3) where seibun3 is not null;
update tTpl set rac4 = (select mid from rac where ippanmei = seibun4) where seibun4 is not null;
update tTpl set rac5 = (select mid from rac where ippanmei = seibun5) where seibun5 is not null;
update tTpl set byochu = re_replace('\(シルバーリーフコナジラミ(幼虫|成虫)?を含む\)', byochu, '') where byochu like '%（シルバーリーフコナジラミ%';
update tTpl set chitai = null where chitai = '-' or chitai = '全地域' or chitai = '全域';
update tTpl set dojo = null where dojo = '-' or dojo = '全土壌';
update tTpl set basho = null where basho = '-';
update tTpl set jikan = null where jikan = '-';
update tTpl set ondo = null where ondo = '-';
select distinct
  yoto,sakumotsu,shurui,tsusho,dokusei,jiki,kaisu,hoho,
  max(ekiryo) as ekiryo,
  basho,jikan,ondo,dojo,chitai,tekiyaku,
  seibun1,kaisu1,keito1,rac1,
  seibun2,kaisu2,keito2,rac2,
  seibun3,kaisu3,keito3,rac3,
  seibun4,kaisu4,keito4,rac4,
  seibun5,kaisu5,keito5,rac5,
  --concat2(x'1d0d', seibun1, seibun2, seibun3, seibun4, seibun5) as ippanmei,
  --concat2(x'1d0d', kaisu1, kaisu2, kaisu3, kaisu4, kaisu5) as 使用回数,
  --concat2(x'1d0d', keito1, keito2, keito3, keito4, keito5) as keito,
  --concat2(x'1d0d', rac1, rac2, rac3, rac4, rac5) as mid,
  --concat2(x'1f0d', if(seibun2 is null, '', '1 ')||seibun1, '2 '||seibun2, '3 '||seibun3, '4 '||seibun4, '5 '||seibun5) as ippanmei,
  --concat2(x'1f0d', if(kaisu2 is null, '', '1 ')||kaisu1, '2 '||kaisu2, '3 '||kaisu3, '4 '||kaisu4, '5 '||kaisu5) as 使用回数,
  --concat2(x'1f0d', if(keito2 is null, '', '1 ')||keito1, '2 '||keito2, '3 '||keito3, '4 '||keito4, '5 '||keito5) as keito,
  --concat2(x'1f0d', if(rac2 is null, '', '1 ')||rac1, '2 '||rac2, '3 '||rac3, '4 '||rac4, '5 '||rac5) as mid,
  concat(', ', if(byochu regexp [%byochu%], concat(' ', baisu, re_replace('^\((.+)\)$', re_replace(replace('(?<!（)[#byochu#]', '類', '(類)?'), re_replace('(成|幼)虫', byochu, '\1'), ''), '\1')), '')) as [#byochu#],
  concat(', ', if(byochu not regexp <%byochu%>, byochu||' '||baisu, '')) as その他,
  count(distinct byochu) as 病害虫数,
  kongo,zaikei,koka,
  if(zenkoku, ryutsu, ifnull(zenkoku, -1) - 1) as 流通,
  min(torokubi) as torokubi
from tTpl
group by sakumotsu, tsusho, dokusei, kaisu, jiki, hoho, basho, jikan, ondo, chitai, tekiyaku
order by yoto, tsusho;
}
</xmp></dd>
<dt>デフォルト定義</dt>
<dd><pre>
#default {
}
</pre></dd>
</dl>
</body>
</html>
