<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<meta name="Author" content="OhYeah!">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="IE=Edge">
<link rel="stylesheet" href="template.css" type="text/css">
<title>ACFinder Template</title>
<script type="text/javascript" src="template.js"></script>
</head>
<body onload="init('耐性リスク',autodep());">
<h1>特定作物殺菌剤FRAC分類 (2024.10.29版)</h1>
<p>特定の作物系統と病害を指定すると、その作物系統に登録のある殺菌剤を検索して、殺菌剤耐性対策委員会(FRAC)の作用点分類等に基づく農薬一覧表を作成します。
殺菌剤のローテーションを考える上で、作用点や耐性リスクを考慮した一覧表を作成したい時にお使いください。</p>
<form name="F1" action="#" id="cbox"></form>
<table id="tcol">
<tbody>
<tr class="header">
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>散布液量</th>
	<th>うどんこ病</th>
	<th>灰色かび病</th>
	<th>べと病</th>
	<th>その他</th>
	<th>成分1</th>
	<th>回数1</th>
	<th>RAC1</th>
	<th>FRAC系統1</th>
	<th>作用機構1</th>
	<th>作用点1</th>
	<th>耐性リスク1</th>
	<th>成分2</th>
	<th>回数2</th>
	<th>RAC2</th>
	<th>FRAC系統2</th>
	<th>作用機構2</th>
	<th>作用点2</th>
	<th>耐性リスク2</th>
	<th>効果</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>きゅうり</td>
	<td>アゾキシストロビン水和剤</td>
	<td>アミスター20フロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>4回以内</td>
	<td>100～300L/10a</td>
	<td>1500～2000倍</td>
	<td>1500倍</td>
	<td>1500～2000倍</td>
	<td>菌核病 1500倍, 褐斑病 2000倍, 炭疽病 2000倍</td>
	<td>アゾキシストロビン</td>
	<td>4回以内</td>
	<td>F:11</td>
	<td>QoI殺菌剤(Qo阻害剤)</td>
	<td>呼吸</td>
	<td>C3:複合体Ⅲユビキノール還元酵素Qo部位</td>
	<td>高(耐性管理ガイドライン有り)</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>治療</td>
	<td>1</td>
	<td>水和剤</td>
	<td>1</td>
	<td>2001.01.30</td>
</tr>
<tr class="even">
	<td>きゅうり</td>
	<td>エタボキサム水和剤</td>
	<td>エトフィンフロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>4回以内</td>
	<td>100～300L/10a</td>
	<td></td>
	<td></td>
	<td>1000倍</td>
	<td></td>
	<td>エタボキサム</td>
	<td>4回以内</td>
	<td>F:22</td>
	<td>チアゾールカルボキサミド</td>
	<td>有糸核分裂と細胞分裂</td>
	<td>B3:β-チュブリン重合阻害</td>
	<td>低～中</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>治療</td>
	<td>1</td>
	<td>水和剤</td>
	<td>-2</td>
	<td>2013.08.06</td>
</tr>
<tr class="odd">
	<td>きゅうり</td>
	<td>フルオピコリド・ベンチアバリカルブイソプロピル水和剤</td>
	<td>ジャストフィットフロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>3回以内</td>
	<td>100～300L/10a</td>
	<td></td>
	<td></td>
	<td>5000倍</td>
	<td></td>
	<td>フルオピコリド</td>
	<td>3回以内</td>
	<td>F:43</td>
	<td>ベンズアミド</td>
	<td>有糸核分裂と細胞分裂</td>
	<td>B5:スペクトリン様蛋白質の非局在化</td>
	<td>耐性菌未発生</td>
	<td>ベンチアバリカルブイソプロピル</td>
	<td>3回以内</td>
	<td>F:40</td>
	<td>CAA殺菌剤(カルボン酸アミド類)</td>
	<td>細胞壁生合成</td>
	<td>H5:セルロース合成酵素</td>
	<td>低～中(耐性管理ガイドライン有り)</td>
	<td>治療</td>
	<td>2</td>
	<td>水和剤</td>
	<td>1</td>
	<td>2012.08.20</td>
</tr>
</tbody>
</table>
<table border="1" id="trow">
<tr class="header">
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>散布液量</th>
	<th>うどんこ病</th>
	<th>灰色かび病</th>
	<th>べと病</th>
	<th>その他</th>
	<th>有効成分</th>
	<th>使用回数</th>
	<th>RACコード</th>
	<th>FRAC系統</th>
	<th>作用機構</th>
	<th>作用点</th>
	<th>FRAC耐性リスク</th>
	<th>効果</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>流通</th>
	<th>登録日</th>
</tr>
<tr class="odd">
	<td>きゅうり</td>
	<td>アゾキシストロビン水和剤</td>
	<td>アミスター20フロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>4回以内</td>
	<td>100～300L/10a</td>
	<td>1500～2000倍</td>
	<td>1500倍</td>
	<td>1500～2000倍</td>
	<td>菌核病 1500倍, 褐斑病 2000倍, 炭疽病 2000倍</td>
	<td>アゾキシストロビン</td>
	<td>4回以内</td>
	<td>F:11</td>
	<td>QoI殺菌剤(Qo阻害剤)</td>
	<td>呼吸</td>
	<td>C3:複合体Ⅲユビキノール還元酵素Qo部位</td>
	<td>高(耐性管理ガイドライン有り)</td>
	<td>治療</td>
	<td>1</td>
	<td>水和剤</td>
	<td>1</td>
	<td>2001.01.30</td>
</tr>
<tr class="even">
	<td>きゅうり</td>
	<td>エタボキサム水和剤</td>
	<td>エトフィンフロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>4回以内</td>
	<td>100～300L/10a</td>
	<td></td>
	<td></td>
	<td>1000倍</td>
	<td></td>
	<td>エタボキサム</td>
	<td>4回以内</td>
	<td>F:22</td>
	<td>チアゾールカルボキサミド</td>
	<td>有糸核分裂と細胞分裂</td>
	<td>B3:β-チュブリン重合阻害</td>
	<td>低～中</td>
	<td>治療</td>
	<td>1</td>
	<td>水和剤</td>
	<td>-2</td>
	<td>2013.08.06</td>
</tr>
<tr class="odd">
	<td>きゅうり</td>
	<td>フルオピコリド・ベンチアバリカルブイソプロピル水和剤</td>
	<td>ジャストフィットフロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>3回以内</td>
	<td>100～300L/10a</td>
	<td></td>
	<td></td>
	<td>5000倍</td>
	<td></td>
	<td>フルオピコリド<br>ベンチアバリカルブイソプロピル</td>
	<td>3回以内<br>3回以内</td>
	<td>F:43<br>F:40</td>
	<td>ベンズアミド<br>CAA殺菌剤(カルボン酸アミド類)</td>
	<td>有糸核分裂と細胞分裂<br>細胞壁生合成</td>
	<td>B5:スペクトリン様蛋白質の非局在化<br>H5:セルロース合成酵素</td>
	<td>耐性菌未発生<br>低～中(耐性管理ガイドライン有り)</td>
	<td>治療</td>
	<td>2</td>
	<td>水和剤</td>
	<td>1</td>
	<td>2012.08.20</td>
</tr>
</table>
<table border="1" id="tclb">
<tr class="header">
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>散布液量</th>
	<th>うどんこ病</th>
	<th>灰色かび病</th>
	<th>べと病</th>
	<th>その他</th>
	<th>有効成分</th>
	<th>使用回数</th>
	<th>RACコード</th>
	<th>FRAC系統</th>
	<th>作用機構</th>
	<th>作用点</th>
	<th>FRAC耐性リスク</th>
	<th>効果</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>流通</th>
	<th>登録日</th>
</tr>
<tr class="odd">
	<td>きゅうり</td>
	<td>アゾキシストロビン水和剤</td>
	<td>アミスター20フロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>4回以内</td>
	<td>100～300L/10a</td>
	<td>1500～2000倍</td>
	<td>1500倍</td>
	<td>1500～2000倍</td>
	<td>菌核病 1500倍, 褐斑病 2000倍, 炭疽病 2000倍</td>
	<td>アゾキシストロビン</td>
	<td>4回以内</td>
	<td>F:11</td>
	<td>QoI殺菌剤(Qo阻害剤)</td>
	<td>呼吸</td>
	<td>C3:複合体Ⅲユビキノール還元酵素Qo部位</td>
	<td>高(耐性管理ガイドライン有り)</td>
	<td>治療</td>
	<td>1</td>
	<td>水和剤</td>
	<td>1</td>
	<td>2001.01.30</td>
</tr>
<tr class="even">
	<td>きゅうり</td>
	<td>エタボキサム水和剤</td>
	<td>エトフィンフロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>4回以内</td>
	<td>100～300L/10a</td>
	<td></td>
	<td></td>
	<td>1000倍</td>
	<td></td>
	<td>エタボキサム</td>
	<td>4回以内</td>
	<td>F:22</td>
	<td>チアゾールカルボキサミド</td>
	<td>有糸核分裂と細胞分裂</td>
	<td>B3:β-チュブリン重合阻害</td>
	<td>低～中</td>
	<td>治療</td>
	<td>1</td>
	<td>水和剤</td>
	<td>-2</td>
	<td>2013.08.06</td>
</tr>
<tr class="odd">
	<td>きゅうり</td>
	<td>フルオピコリド・ベンチアバリカルブイソプロピル水和剤</td>
	<td>ジャストフィットフロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>3回以内</td>
	<td>100～300L/10a</td>
	<td></td>
	<td></td>
	<td>5000倍</td>
	<td></td>
	<td>1 フルオピコリド<br>2 ベンチアバリカルブイソプロピル</td>
	<td>1 3回以内<br>2 3回以内</td>
	<td>1 F:43<br>2 F:40</td>
	<td>1 ベンズアミド<br>2 CAA殺菌剤(カルボン酸アミド類)</td>
	<td>1 有糸核分裂と細胞分裂<br>2 細胞壁生合成</td>
	<td>1 B5:スペクトリン様蛋白質の非局在化<br>2 H5:セルロース合成酵素</td>
	<td>1 耐性菌未発生<br>2 低～中(耐性管理ガイドライン有り)</td>
	<td>治療</td>
	<td>2</td>
	<td>水和剤</td>
	<td>1</td>
	<td>2012.08.20</td>
</tr>
</table>
<h2>設定項目</h2>
<dl>
<dt>■ 作物名</dt>
<dd>
<p>検索対象とする作物系統を１系統のみ指定できます。<em>[必須]</em></p>
<p>「作物群一括検索」で「する」を選択した場合、作物名に「'きゅうり'」だけを指定しても「きゅうり」以外に上位作物群の「うり類(未成熟),うり科野菜類,うり類,野菜類」のほか、
下位作物群である「きゅうり(施設栽培),きゅうり(露地栽培(移植栽培)),きゅうり(露地栽培(直播栽培))」も含めて検索します。
作物名に「'きゅうり(施設栽培)'」を指定した場合は、上位作物群の「きゅうり,うり類(未成熟),うり科野菜類,うり類,野菜類」(ただし「野菜類(露地栽培)」は除く)を検索します。</p>
<p>登録農薬が多い作物で大作物群などの上位作物群まで含めて検索したくない場合は、「作物群一括検索」で「しない」を選択し、
「'きゅうり(施設野菜),きゅうり'」あるいは「'きゅうり,うり類(未成熟),うり科野菜類,うり類'」などのように遡る作物群を限定します。
作物群一括検索「しない」でも、「'きゅうり'」を指定した場合、下位作物群である「きゅうり(施設栽培),きゅうり(露地栽培(移植栽培)),きゅうり(露地栽培(直播栽培))」も含めて検索します。</p>
</dd>
<dt>■ 病害虫</dt>
<dd>
<p>検索対象とする病害を複数指定できます。<em>[必須]</em></p>
<p>一覧にしたい主な病害を指定してください。ここで指定しなかった病害は「その他」に列挙されますので、全てを指定する必要はありません。
<em>耐性リスクが高い菌に耐性リスクが高くFRAC分類が同じ剤を連用すると耐性菌発現リスクが飛躍的に高まる</em>ため、耐性リスクが高い菌が病原菌の病害を指定するのが良いでしょう。
耐性リスクが高い菌は、灰色かび病、麦類のうどんこ病、うり類のうどんこ病、ぶどうのべと病、うり類のべと病、りんご・なしの黒星病、じゃがいも・トマトの疫病、稲・芝のいもち病です。</p>
</dd>
<dt>□ 剤型</dt>
<dd>
<p>検索対象とする剤型を複数選択できます。無指定の場合は、全ての剤型を検索します。</p>
<p>噴霧剤だけを検索したい場合は、「噴霧剤.arg」を読み込んでください。</p>
</dd>
<dt>□ その他</dt>
<dd>
<p>上記以外の項目を検索条件にしたい場合、条件式を直接記述します。使用時期・使用方法などを限定したい場合や、特定の通称のみを表示したい場合などに使用します。</p>
<p>収穫期に使用可能な散布剤だけを検索したい場合は、「収穫期散布剤.arg」を読み込んでください。</p>
</dd>
</dl>
<h2>設定例</h2>
<div>
<p><span class="button">設定読込</span>ボタンをクリックして、下記ファイルを選択してください。</p>
<pre>
施設きゅうりFRAC分類.arg
施設トマトFRAC分類.arg
</pre>
</div>
<h2>定義</h2>
<dl>
<dt>テンプレート定義</dt>
<dd><xmp id="sql">
#template {
--/d
drop table if exists tTpl;
create temp table tTpl as
select distinct
  bango,sakumotsu,shurui,tsusho,dokusei,jiki,kaisu,hoho,ekiryo,byochu,baisu,
  seibun1,seibun2,seibun3,seibun4,seibun5,
  kaisu1, kaisu2,kaisu3,kaisu4,kaisu5,
  null as rac1, null as rac2, null as rac3, null as rac4, null as rac5,
  null as fg1, null as fg2, null as fg3, null as fg4, null as fg5,
  null as sayokiko1, null as sayokiko2, null as sayokiko3, null as sayokiko4, null as sayokiko5,
  null as sayoten1, null as sayoten2, null as sayoten3, null as sayoten4, null as sayoten5,
  null as risk1, null as risk2, null as risk3, null as risk4, null as risk5,
  koka,kongo,zaikei,
  zenkoku as ryutsu,
  zenkoku,torokubi
from m_tekiyo left join m_kihon using(bango) left join seizai using(bango) left join idshurui using(bango) left join ryutsu using(idshurui)
where
  yoto = '殺菌剤' and
  --ryakusho <> 'ホクサン株式会社' and
  --ryakusho <> '琉球産経株式会社' and
  --zaikei in (<zaikei>) and
  --<sonota> and
  (shurui <> '展着剤' and concat('、', hoho, basho) not regexp '倉庫|貯蔵|気密|天幕|サイロ') and
  sakumotsu in (select sakumotsu from m_sakumotsu left join sakuhojo using(idsaku) where 
    '、'||concat('、', sakumotsu, shozoku)||'、' regexp <~sakumotsu~> and nozoku not regexp <~sakumotsu~> or fukumu regexp <~sakumotsu~>
  );
update tTpl set kaisu1 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun1), kaisu1) where kaisu1 is not null;
update tTpl set kaisu2 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun2), kaisu2) where kaisu2 is not null;
update tTpl set kaisu3 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun3), kaisu3) where kaisu3 is not null;
update tTpl set kaisu4 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun4), kaisu4) where kaisu4 is not null;
update tTpl set kaisu5 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun5), kaisu5) where kaisu5 is not null;
update tTpl set rac1 = (select mid from rac2 where mid like 'F:%' and ippanmei = seibun1) where seibun1 is not null;
update tTpl set rac2 = (select mid from rac2 where mid like 'F:%' and ippanmei = seibun2) where seibun2 is not null;
update tTpl set rac3 = (select mid from rac2 where mid like 'F:%' and ippanmei = seibun3) where seibun3 is not null;
update tTpl set rac4 = (select mid from rac2 where mid like 'F:%' and ippanmei = seibun4) where seibun4 is not null;
update tTpl set rac5 = (select mid from rac2 where mid like 'F:%' and ippanmei = seibun5) where seibun5 is not null;
update tTpl set fg1 = (select replace(fgroup,'FRAC系統名: ','') from rac2 where mid like 'F:%' and ippanmei = seibun1) where seibun1 is not null;
update tTpl set fg2 = (select replace(fgroup,'FRAC系統名: ','') from rac2 where mid like 'F:%' and ippanmei = seibun2) where seibun2 is not null;
update tTpl set fg3 = (select replace(fgroup,'FRAC系統名: ','') from rac2 where mid like 'F:%' and ippanmei = seibun3) where seibun3 is not null;
update tTpl set fg4 = (select replace(fgroup,'FRAC系統名: ','') from rac2 where mid like 'F:%' and ippanmei = seibun4) where seibun4 is not null;
update tTpl set fg5 = (select replace(fgroup,'FRAC系統名: ','') from rac2 where mid like 'F:%' and ippanmei = seibun5) where seibun5 is not null;
update tTpl set sayokiko1 = (select sayokiko from rac2 where mid like 'F:%' and ippanmei = seibun1) where seibun1 is not null;
update tTpl set sayokiko2 = (select sayokiko from rac2 where mid like 'F:%' and ippanmei = seibun2) where seibun2 is not null;
update tTpl set sayokiko3 = (select sayokiko from rac2 where mid like 'F:%' and ippanmei = seibun3) where seibun3 is not null;
update tTpl set sayokiko4 = (select sayokiko from rac2 where mid like 'F:%' and ippanmei = seibun4) where seibun4 is not null;
update tTpl set sayokiko5 = (select sayokiko from rac2 where mid like 'F:%' and ippanmei = seibun5) where seibun5 is not null;
update tTpl set sayoten1 = (select sayoten from rac2 where mid like 'F:%' and ippanmei = seibun1) where seibun1 is not null;
update tTpl set sayoten2 = (select sayoten from rac2 where mid like 'F:%' and ippanmei = seibun2) where seibun2 is not null;
update tTpl set sayoten3 = (select sayoten from rac2 where mid like 'F:%' and ippanmei = seibun3) where seibun3 is not null;
update tTpl set sayoten4 = (select sayoten from rac2 where mid like 'F:%' and ippanmei = seibun4) where seibun4 is not null;
update tTpl set sayoten5 = (select sayoten from rac2 where mid like 'F:%' and ippanmei = seibun5) where seibun5 is not null;
update tTpl set risk1 = (select risk from rac2 where mid like 'F:%' and ippanmei = seibun1) where seibun1 is not null;
update tTpl set risk2 = (select risk from rac2 where mid like 'F:%' and ippanmei = seibun2) where seibun2 is not null;
update tTpl set risk3 = (select risk from rac2 where mid like 'F:%' and ippanmei = seibun3) where seibun3 is not null;
update tTpl set risk4 = (select risk from rac2 where mid like 'F:%' and ippanmei = seibun4) where seibun4 is not null;
update tTpl set risk5 = (select risk from rac2 where mid like 'F:%' and ippanmei = seibun5) where seibun5 is not null;
select distinct
  sakumotsu,shurui,tsusho, dokusei,jiki,kaisu,
  max(ekiryo) as ekiryo,
  max(case when byochu regexp [%byochu%] then baisu else '' end) as [#byochu#],
  concat(', ', case when byochu not regexp <%byochu%> then byochu||' '||baisu else '' end) as その他,
  seibun1,kaisu1,rac1,fg1 as FRAC系統1,sayokiko1 as 作用機構1,sayoten1 as 作用点1,risk1 as 耐性リスク1,
  seibun2,kaisu2,rac2,fg2 as FRAC系統2,sayokiko2 as 作用機構2,sayoten2 as 作用点2,risk2 as 耐性リスク2,
  seibun3,kaisu3,rac3,fg3 as FRAC系統3,sayokiko3 as 作用機構3,sayoten3 as 作用点3,risk3 as 耐性リスク3,
  seibun4,kaisu4,rac4,fg4 as FRAC系統4,sayokiko4 as 作用機構4,sayoten4 as 作用点4,risk4 as 耐性リスク4,
  seibun5,kaisu5,rac5,fg5 as FRAC系統5,sayokiko5 as 作用機構5,sayoten5 as 作用点5,risk5 as 耐性リスク5,
  --concat2(x'1d0d', seibun1, seibun2, seibun3, seibun4, seibun5) as ippanmei,
  --concat2(x'1d0d', kaisu1, kaisu2, kaisu3, kaisu4, kaisu5) as 使用回数,
  --concat2(x'1d0d', rac1, rac2, rac3, rac4, rac5) as mid,
  --concat2(x'1d0d', fg1, fg2, fg3, fg4, fg5) as FRAC系統,
  --concat2(x'1d0d', sayokiko1, sayokiko2, sayokiko3, sayokiko4, sayokiko5) as sayokiko,
  --concat2(x'1d0d', sayoten1, sayoten2, sayoten3, sayoten4, sayoten5) as sayoten,
  --concat2(x'1d0d', risk1, risk2, risk3, risk4, risk5) as risk,
  --concat2(x'1f0d', if(seibun2 is null, '', '1 ')||seibun1, '2 '||seibun2, '3 '||seibun3, '4 '||seibun4, '5 '||seibun5) as ippanmei,
  --concat2(x'1f0d', if(kaisu2 is null, '', '1 ')||kaisu1, '2 '||kaisu2, '3 '||kaisu3, '4 '||kaisu4, '5 '||kaisu5) as 使用回数,
  --concat2(x'1f0d', if(rac2 is null, '', '1 ')||rac1, '2 '||rac2, '3 '||rac3, '4 '||rac4, '5 '||rac5) as mid,
  --concat2(x'1f0d', if(fg2 is null, '', '1 ')||fg1, '2 '||fg2, '3 '||fg3, '4 '||fg4, '5 '||fg5) as FRAC系統,
  --concat2(x'1f0d', if(sayokiko2 is null, '', '1 ')||sayokiko1, '2 '||sayokiko2, '3 '||sayokiko3, '4 '||sayokiko4, '5 '||sayokiko5) as sayokiko,
  --concat2(x'1f0d', if(sayoten2 is null, '', '1 ')||sayoten1, '2 '||sayoten2, '3 '||sayoten3, '4 '||sayoten4, '5 '||sayoten5) as sayoten,
  --concat2(x'1f0d', if(risk2 is null, '', '1 ')||risk1, '2 '||risk2, '3 '||risk3, '4 '||risk4, '5 '||risk5) as risk,
  (re_replace('.*\((.+)\).*', koka, '\1')) as koka,
  kongo,zaikei,
  if(zenkoku, ryutsu, ifnull(zenkoku, -1) - 1) as 流通,
  min(torokubi) as torokubi
from tTpl
group by sakumotsu, tsusho, dokusei, kaisu, jiki, hoho
order by tsusho;
}
</xmp></dd>
<dt>デフォルト定義</dt>
<dd><pre>
#default {
}
</pre></dd>
</dl>
</body>
</html>
