<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<meta name="Author" content="OhYeah!">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="IE=Edge">
<link rel="stylesheet" href="template.css" type="text/css">
<title>ACFinder Template</title>
<script type="text/javascript" src="template.js"></script>
<script type="text/javascript">
</script>
</head>
<body onload="init('',autodep(),ExcSprd());">
<h1>指定作物農薬一覧 (2024.10.21版)</h1>
<p>特定の作物系統または複数の作物系統を指定すると、その作物系統に登録のある農薬を検索して、下記のような一覧表を作成します。
「指定作物農薬／病害虫対応一覧」と似ていますが、対象病害虫及び希釈倍数・使用量が一つの枠に集約されることと、植調剤も表示できるところが異なります。</p>
<form name="F1" action="#" id="cbox"></form>
<table border="1" id="tcol">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>使用方法</th>
	<th>散布液量</th>
	<th>成分1</th>
	<th>回数1</th>
	<th>系統1</th>
	<th>RAC1</th>
	<th>成分2</th>
	<th>回数2</th>
	<th>系統2</th>
	<th>RAC2</th>
	<th>対象病害虫等</th>
	<th>対象病害虫数</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>豆類(未成熟、ただし、さやえんどうを除く)</td>
	<td>ペンチオピラド水和剤</td>
	<td>アフェットフロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>3回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>ペンチオピラド</td>
	<td>3回以内</td>
	<td>チオフェン系</td>
	<td>F:7</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>灰色かび病 2000倍, 菌核病 2000倍</td>
	<td>2</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>2008.07.23</td>
</tr>
<tr class="even">
	<td>殺菌剤</td>
	<td>さやいんげん</td>
	<td>ボスカリド水和剤</td>
	<td>カンタスドライフロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>3回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>ボスカリド</td>
	<td>3回以内</td>
	<td>カルボキシアミド</td>
	<td>F:7</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>灰色かび病 1000倍, 菌核病 1000倍</td>
	<td>2</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>2005.01.17</td>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>野菜類(なすを除く)</td>
	<td>炭酸水素ナトリウム・銅水和剤</td>
	<td>ジーファイン水和剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>-</td>
	<td>散布</td>
	<td>150～500L/10a</td>
	<td>炭酸水素ナトリウム</td>
	<td>-</td>
	<td>炭酸水素塩</td>
	<td>F:NC</td>
	<td>銅</td>
	<td>-</td>
	<td>無機銅</td>
	<td>F:M1</td>
	<td>白さび病 1000倍, うどんこ病 750～1000倍, 軟腐病 1000倍</td>
	<td>3</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1993.12.01</td>
</tr>
</table>
<table border="1" id="trow">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>使用方法</th>
	<th>散布液量</th>
	<th>有効成分</th>
	<th>使用回数</th>
	<th>系統名</th>
	<th>RACコード</th>
	<th>対象病害虫等</th>
	<th>対象病害虫数</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>豆類(未成熟、ただし、さやえんどうを除く)</td>
	<td>ペンチオピラド水和剤</td>
	<td>アフェットフロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>3回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>ペンチオピラド</td>
	<td>3回以内</td>
	<td>チオフェン系</td>
	<td>F:7</td>
	<td>灰色かび病 2000倍, 菌核病 2000倍</td>
	<td>2</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>2008.07.23</td>
</tr>
<tr class="even">
	<td>殺菌剤</td>
	<td>さやいんげん</td>
	<td>ボスカリド水和剤</td>
	<td>カンタスドライフロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>3回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>ボスカリド</td>
	<td>3回以内</td>
	<td>カルボキシアミド</td>
	<td>F:7</td>
	<td>灰色かび病 1000倍, 菌核病 1000倍</td>
	<td>2</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>2005.01.17</td>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>野菜類(なすを除く)</td>
	<td>炭酸水素ナトリウム・銅水和剤</td>
	<td>ジーファイン水和剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>-</td>
	<td>散布</td>
	<td>150～500L/10a</td>
	<td>炭酸水素ナトリウム<br>銅</td>
	<td>-<br>-</td>
	<td>炭酸水素塩<br>無機銅</td>
	<td>F:NC<br>F:M1</td>
	<td>白さび病 1000倍, うどんこ病 750～1000倍, 軟腐病 1000倍</td>
	<td>3</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1993.12.01</td>
</tr>
</table>
<table border="1" id="tclb">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>使用方法</th>
	<th>散布液量</th>
	<th>有効成分</th>
	<th>使用回数</th>
	<th>系統名</th>
	<th>RACコード</th>
	<th>対象病害虫等</th>
	<th>対象病害虫数</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>豆類(未成熟、ただし、さやえんどうを除く)</td>
	<td>ペンチオピラド水和剤</td>
	<td>アフェットフロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>3回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>ペンチオピラド</td>
	<td>3回以内</td>
	<td>チオフェン系</td>
	<td>F:7</td>
	<td>灰色かび病 2000倍, 菌核病 2000倍</td>
	<td>2</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>2008.07.23</td>
</tr>
<tr class="even">
	<td>殺菌剤</td>
	<td>さやいんげん</td>
	<td>ボスカリド水和剤</td>
	<td>カンタスドライフロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>3回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>ボスカリド</td>
	<td>3回以内</td>
	<td>カルボキシアミド</td>
	<td>F:7</td>
	<td>灰色かび病 1000倍, 菌核病 1000倍</td>
	<td>2</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>2005.01.17</td>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>野菜類(なすを除く)</td>
	<td>炭酸水素ナトリウム・銅水和剤</td>
	<td>ジーファイン水和剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>-</td>
	<td>散布</td>
	<td>150～500L/10a</td>
	<td>1 炭酸水素ナトリウム<br>2 銅</td>
	<td>1 -<br>2 -</td>
	<td>1 炭酸水素塩<br>2 無機銅</td>
	<td>1 F:NC<br>2 F:M1</td>
	<td>白さび病 1000倍, うどんこ病 750～1000倍, 軟腐病 1000倍</td>
	<td>3</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1993.12.01</td>
</tr>
</table>
<h2>設定項目</h2>
<dl>
<dt>■ 作物名</dt>
<dd>
<p>検索対象とする作物系統を複数指定できます。<em>[必須]</em></p>
<p>「作物群一括検索」で「する」を選択した場合、作物名に「'きゅうり'」だけを指定しても「きゅうり」以外に上位作物群の「うり類(未成熟),うり科野菜類,うり類,野菜類」のほか、
下位作物群として「きゅうり(施設栽培),きゅうり(露地栽培(移植栽培)),きゅうり(露地栽培(直播栽培)),野菜類(施設栽培),野菜類(露地栽培)」のような各作物群の詳細作物名も含めて検索します。
作物名に「'きゅうり(施設栽培)'」を指定した場合は、上位作物群の「きゅうり,うり類(未成熟),うり科野菜類,うり類,野菜類」(ただし「(露地栽培)」のような相反する詳細作物名は除く)を検索します。</p>
<p>登録農薬が多い作物で大作物群などの上位作物群まで含めて検索したくない場合は、「作物群一括検索」で「しない」を選択し、
「'きゅうり(施設野菜),きゅうり'」あるいは「'きゅうり,うり類(未成熟),うり科野菜類,うり類'」などのように遡る作物群を限定します。
作物群一括検索「しない」でも、「'きゅうり'」を指定した場合、下位作物群である「きゅうり(施設栽培),きゅうり(露地栽培(移植栽培)),きゅうり(露地栽培(直播栽培))」も含めて検索します。</p>
<p>検索対象の作物系統は、複数の指定が可能です。
「'ししとう','甘長とうがらし'」のように指定すると、「ししとう」または「甘長とうがらし」のいずれか、あるいは両方に登録のある農薬が検索できます。</p>
</dd>
<dt>□ 病害虫</dt>
<dd>
<p>検索対象とする病害虫・雑草を指定します(複数指定可)。無指定の場合は、全ての病害虫・雑草を検索します。</p>
<p>「その他」の設定と併用して、「無人航空機」で使用可能な「赤かび病」の薬剤を検索したい場合などに使用します。</p>
</dd>
<dt>□ 用途</dt>
<dd>
<p>検索対象とする用途を指定します(複数指定可)。無指定の場合は、全ての用途を検索します。</p>
<p>複数指定可能ですが、殺虫剤一覧を作成する場合は「殺虫剤」または「殺虫剤, 殺虫殺菌剤」、殺菌剤一覧を作成する場合は「殺菌剤」または「殺菌剤, 殺虫殺菌剤」を選択すると良いでしょう。</p>
</dd>
<dt>□ 剤型</dt>
<dd>
<p>検索対象とする剤型を指定します(複数指定可)。無指定の場合は、全ての剤型を検索します。</p>
<p>噴霧剤だけを検索したい場合は、「希釈散布剤.arg」を読み込んでください。</p>
</dd>
<dt>□ その他</dt>
<dd>
<p>上記以外の項目を検索条件にしたい場合、条件式を直接記述します。使用時期・使用方法などを限定したい場合や、特定の通称のみを表示したい場合などに使用します。</p>
<p>収穫期に使用可能な散布剤だけを検索したい場合は、「収穫期散布剤.arg」を読み込んでください。</p>
<p>無人航空機、水口施用、投げ込み、常温煙霧に対応する薬剤を検索したい場合は、それぞれ「無人航空機.arg」「水口施用.arg」「投げ込み.arg」「常温煙霧.arg」を読み込んでください。</p>
</dd>
</dl>
<h2>設定例</h2>
<div>
<p><span class="button">設定読込</span>ボタンをクリックして、下記ファイルを選択してください。
「さやいんげん○○」は単一作物系統指定の例、「麦類赤かび病農薬一覧」は複数作物系統指定の例となります。</p>
<pre>
さやいんげん殺虫剤.arg
さやいんげん収穫期希釈散布殺菌剤.arg
麦類赤かび病農薬一覧.arg
</pre>
</div>
<h2>定義</h2>
<dl>
<dt>テンプレート定義</dt>
<dd><xmp id="sql">
#template {
--/d
drop table if exists tTpl;
create temp table tTpl as
select distinct
  bango,yoto,sakumotsu,shurui,tsusho,dokusei,jiki,kaisu,hoho,
  byochu,mokuteki,baisu,ekiryo,basho,jikan,ondo,dojo,chitai,tekiyaku,
  seibun1,seibun2,seibun3,seibun4,seibun5,
  kaisu1,kaisu2,kaisu3,kaisu4,kaisu5,
  keito1,keito2,keito3,keito4,keito5,
  null as rac1, null as rac2, null as rac3, null as rac4, null as rac5,
  kongo,zaikei,koka,
  zenkoku as ryutsu,
  zenkoku,torokubi
from m_tekiyo left join m_kihon using(bango) left join seizai using(bango) left join idshurui using(bango) left join ryutsu using(idshurui)
where
  --ryakusho <> 'ホクサン株式会社' and
  --ryakusho <> '琉球産経株式会社' and
  --byochu in (<byochu>) and
  --yoto in (<yoto>) and
  --zaikei in (<zaikei>) and
  --<sonota> and
  (shurui <> '展着剤' and concat('、', hoho, basho) not regexp '倉庫|貯蔵|気密|天幕|サイロ') and
  sakumotsu in (select sakumotsu from m_sakumotsu left join sakuhojo using(idsaku) where 
    ('、'||concat('、', sakumotsu, shozoku)||'、' regexp [~sakumotsu~] and nozoku not regexp [~sakumotsu~] or fukumu regexp [~sakumotsu~]) or
    0
  );
update tTpl set kaisu1 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun1), kaisu1) where kaisu1 is not null;
update tTpl set kaisu2 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun2), kaisu2) where kaisu2 is not null;
update tTpl set kaisu3 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun3), kaisu3) where kaisu3 is not null;
update tTpl set kaisu4 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun4), kaisu4) where kaisu4 is not null;
update tTpl set kaisu5 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun5), kaisu5) where kaisu5 is not null;
update tTpl set rac1 = (select mid from rac where ippanmei = seibun1) where seibun1 is not null;
update tTpl set rac2 = (select mid from rac where ippanmei = seibun2) where seibun2 is not null;
update tTpl set rac3 = (select mid from rac where ippanmei = seibun3) where seibun3 is not null;
update tTpl set rac4 = (select mid from rac where ippanmei = seibun4) where seibun4 is not null;
update tTpl set rac5 = (select mid from rac where ippanmei = seibun5) where seibun5 is not null;
select
  yoto,sakumotsu,shurui,tsusho,dokusei,jiki,kaisu,hoho,ekiryo,
  basho,jikan,ondo,dojo,chitai,tekiyaku,
  seibun1,kaisu1,keito1,rac1,
  seibun2,kaisu2,keito2,rac2,
  seibun3,kaisu3,keito3,rac3,
  seibun4,kaisu4,keito4,rac4,
  seibun5,kaisu5,keito5,rac5,
  --concat2(x'1d0d', seibun1, seibun2, seibun3, seibun4, seibun5) as ippanmei,
  --concat2(x'1d0d', kaisu1, kaisu2, kaisu3, kaisu4, kaisu5) as 使用回数,
  --concat2(x'1d0d', keito1, keito2, keito3, keito4, keito5) as keito,
  --concat2(x'1d0d', rac1, rac2, rac3, rac4, rac5) as mid,
  --concat2(x'1f0d', if(seibun2 is null, '', '1 ')||seibun1, '2 '||seibun2, '3 '||seibun3, '4 '||seibun4, '5 '||seibun5) as ippanmei,
  --concat2(x'1f0d', if(kaisu2 is null, '', '1 ')||kaisu1, '2 '||kaisu2, '3 '||kaisu3, '4 '||kaisu4, '5 '||kaisu5) as 使用回数,
  --concat2(x'1f0d', if(keito2 is null, '', '1 ')||keito1, '2 '||keito2, '3 '||keito3, '4 '||keito4, '5 '||keito5) as keito,
  --concat2(x'1f0d', if(rac2 is null, '', '1 ')||rac1, '2 '||rac2, '3 '||rac3, '4 '||rac4, '5 '||rac5) as mid,
  concat(', ', concat('', byochu, mokuteki, ' ', baisu)) as 対象病害虫等,
  count(distinct concat('', byochu, mokuteki)) as 対象病害虫数,
  kongo,zaikei,koka,
  if(zenkoku, ryutsu, ifnull(zenkoku, -1) - 1) as 流通,
  min(torokubi) as torokubi
from tTpl
group by sakumotsu, tsusho, dokusei, kaisu, jiki, hoho, ekiryo, basho, jikan, ondo, chitai, tekiyaku
order by yoto, tsusho;
}
</xmp></dd>
<dt>デフォルト定義</dt>
<dd><pre>
#default {
}
</pre></dd>
</dl>
</body>
</html>
