<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<meta name="Author" content="OhYeah!">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="IE=Edge">
<link rel="stylesheet" href="template.css" type="text/css">
<title>ACFinder Template</title>
<script type="text/javascript" src="template.js"></script>
<script type="text/javascript">
function opt1() {
  var cbox =
  '<li>栽培様式<select name="O1" onChange="SelMethod()">'+
  '<option value="transplant">移植'+
  '<option value="directseeding">直播'+
  '</select><div class="balloon">'+
  '<p>「移植」「直播」から選択すると、それぞれの栽培様式で使用可能な農薬の一覧表を作成します。</p>'+
  '<span class="arrow"><span class="inarrow"></span></span>'+
  "</div></li>\r\n";
  return cbox;
}
function SelMethod() {
  var n = document.F1.O1.selectedIndex;
  var ctyp = document.F1.O1.options[n].value;
  var node = document.getElementById('sql');
  if (ctyp == 'transplant') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/'直播水稲'/, "'移植水稲'");
  } else {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/'移植水稲'/, "'直播水稲'");
  }
}
</script>
</head>
<body onload="init('',opt1());">
<h1>飼料用籾米出穂以降使用可能農薬一覧 (2023.11.9版)</h1>
<p>特定の用途を指定すると、その用途の農薬の中から<a target="_blank" href="http://www.maff.go.jp/j/chikusan/sinko/lin/l_siryo/#esamai">飼料として使用する籾米への農薬の使用について(農林水産省関係課長連名通知)</a>により改訂された飼料用米の生産・給与技術マニュアル基づいて籾米あるいは籾殻を含めた米を飼料として家畜に給与する場合に、出穂以降でも使用可能な剤を検索して、下記のような一覧表を作成します。</p>
<p>使用可能農薬の根拠となる通知の日付・発番は、SQLタブで「籾米.qry」を読み込んで実行すると確認できます。</p>
<form name="F1" action="#" id="cbox"></form>
<table border="1" id="tcol">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>本剤の使用回数</th>
	<th>使用時期</th>
	<th>希釈倍数使用量</th>
	<th>散布液量</th>
	<th>使用方法</th>
	<th>成分1</th>
	<th>回数1</th>
	<th>系統1</th>
	<th>RAC1</th>
	<th>成分2</th>
	<th>回数2</th>
	<th>系統2</th>
	<th>RAC2</th>
	<th>適用病害虫雑草名</th>
	<th>混合</th>
	<th>剤型</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺虫剤</td>
	<td>稲</td>
	<td>クロマフェノジド水和剤</td>
	<td>マトリックフロアブル</td>
	<td>普</td>
	<td>2回以内</td>
	<td>収穫7日前まで</td>
	<td>1000倍</td>
	<td>100～200L/10a</td>
	<td>散布</td>
	<td>クロマフェノジド</td>
	<td>2回以内</td>
	<td>ジアシルヒドラジン(IGR脱皮促進)</td>
	<td>I:18</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>コブノメイガ</td>
	<td>1</td>
	<td>水和剤</td>
	<td>1</td>
	<td>1999.12.27</td>
</tr>
<tr class="even">
	<td>殺虫殺菌剤</td>
	<td>稲</td>
	<td>エチプロール・オリサストロビン粒剤</td>
	<td>嵐キラップ粒剤</td>
	<td>普</td>
	<td>1回</td>
	<td>収穫21日前まで</td>
	<td>3kg/10a</td>
	<td></td>
	<td>散布</td>
	<td>エチプロール</td>
	<td>2回以内(移植時までの処理は1回以内)</td>
	<td>フェニルピラゾール</td>
	<td>I:2(B)</td>
	<td>オリサストロビン</td>
	<td>2回以内(移植前は1回以内、本田では1回以内)</td>
	<td>ストロビルリン</td>
	<td>F:11</td>
	<td>いもち病,ウンカ類,カメムシ類,墨黒穂病,穂枯れ(ごま葉枯病菌),紋枯病</td>
	<td>2</td>
	<td>粒剤</td>
	<td>1</td>
	<td>2008.02.06</td>
</tr>
<tr class="odd">
	<td>除草剤</td>
	<td>移植水稲</td>
	<td>フルセトスルフロン粒剤</td>
	<td>スケダチエース1キロ粒剤</td>
	<td>普</td>
	<td>2回以内</td>
	<td>移植後14日～ノビエ5葉期 但し、収穫45日前まで</td>
	<td>1kg/10a</td>
	<td></td>
	<td>湛水散布又は無人ヘリコプターによる散布</td>
	<td>フルセトスルフロン</td>
	<td>2回以内</td>
	<td>スルホニルウレア</td>
	<td>H:B</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>ウリカワ,クログワイ,コウキヤガラ,ノビエ,ヒルムシロ,ヘラオモダカ,マツバイ</td>
	<td>1</td>
	<td>粒剤</td>
	<td>-2</td>
	<td>2015.02.04</td>
</tr>
</table>
<table border="1" id="trow">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>本剤の使用回数</th>
	<th>使用時期</th>
	<th>希釈倍数使用量</th>
	<th>散布液量</th>
	<th>使用方法</th>
	<th>有効成分</th>
	<th>使用回数</th>
	<th>系統名</th>
	<th>RACコード</th>
	<th>適用病害虫雑草名</th>
	<th>混合</th>
	<th>剤型</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺虫剤</td>
	<td>稲</td>
	<td>クロマフェノジド水和剤</td>
	<td>マトリックフロアブル</td>
	<td>普</td>
	<td>2回以内</td>
	<td>収穫7日前まで</td>
	<td>1000倍</td>
	<td>100～200L/10a</td>
	<td>散布</td>
	<td>クロマフェノジド</td>
	<td>2回以内</td>
	<td>ジアシルヒドラジン(IGR脱皮促進)</td>
	<td>I:18</td>
	<td>コブノメイガ</td>
	<td>1</td>
	<td>水和剤</td>
	<td>1</td>
	<td>1999.12.27</td>
</tr>
<tr class="even">
	<td>殺虫殺菌剤</td>
	<td>稲</td>
	<td>エチプロール・オリサストロビン粒剤</td>
	<td>嵐キラップ粒剤</td>
	<td>普</td>
	<td>1回</td>
	<td>収穫21日前まで</td>
	<td>3kg/10a</td>
	<td></td>
	<td>散布</td>
	<td>エチプロール<br>オリサストロビン</td>
	<td>2回以内(移植時までの処理は1回以内)<br>2回以内(移植前は1回以内、本田では1回以内)</td>
	<td>フェニルピラゾール<br>ストロビルリン</td>
	<td>I:2(B)<br>F:11</td>
	<td>いもち病,ウンカ類,カメムシ類,墨黒穂病,穂枯れ(ごま葉枯病菌),紋枯病</td>
	<td>2</td>
	<td>粒剤</td>
	<td>1</td>
	<td>2008.02.06</td>
</tr>
<tr class="odd">
	<td>除草剤</td>
	<td>移植水稲</td>
	<td>フルセトスルフロン粒剤</td>
	<td>スケダチエース1キロ粒剤</td>
	<td>普</td>
	<td>2回以内</td>
	<td>移植後14日～ノビエ5葉期 但し、収穫45日前まで</td>
	<td>1kg/10a</td>
	<td></td>
	<td>湛水散布又は無人ヘリコプターによる散布</td>
	<td>フルセトスルフロン</td>
	<td>2回以内</td>
	<td>スルホニルウレア</td>
	<td>H:B</td>
	<td>ウリカワ,クログワイ,コウキヤガラ,ノビエ,ヒルムシロ,ヘラオモダカ,マツバイ</td>
	<td>1</td>
	<td>粒剤</td>
	<td>-2</td>
	<td>2015.02.04</td>
</tr>
</table>
<table border="1" id="tclb">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>本剤の使用回数</th>
	<th>使用時期</th>
	<th>希釈倍数使用量</th>
	<th>散布液量</th>
	<th>使用方法</th>
	<th>有効成分</th>
	<th>使用回数</th>
	<th>系統名</th>
	<th>RACコード</th>
	<th>適用病害虫雑草名</th>
	<th>混合</th>
	<th>剤型</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺虫剤</td>
	<td>稲</td>
	<td>クロマフェノジド水和剤</td>
	<td>マトリックフロアブル</td>
	<td>普</td>
	<td>2回以内</td>
	<td>収穫7日前まで</td>
	<td>1000倍</td>
	<td>100～200L/10a</td>
	<td>散布</td>
	<td>クロマフェノジド</td>
	<td>2回以内</td>
	<td>ジアシルヒドラジン(IGR脱皮促進)</td>
	<td>I:18</td>
	<td>コブノメイガ</td>
	<td>1</td>
	<td>水和剤</td>
	<td>1</td>
	<td>1999.12.27</td>
</tr>
<tr class="even">
	<td>殺虫殺菌剤</td>
	<td>稲</td>
	<td>エチプロール・オリサストロビン粒剤</td>
	<td>嵐キラップ粒剤</td>
	<td>普</td>
	<td>1回</td>
	<td>収穫21日前まで</td>
	<td>3kg/10a</td>
	<td></td>
	<td>散布</td>
	<td>1.エチプロール<br>2.オリサストロビン</td>
	<td>1.2回以内(移植時までの処理は1回以内)<br>2.2回以内(移植前は1回以内、本田では1回以内)</td>
	<td>1.フェニルピラゾール<br>2.ストロビルリン</td>
	<td>1.I:2(B)<br>2.F:11</td>
	<td>いもち病,ウンカ類,カメムシ類,墨黒穂病,穂枯れ(ごま葉枯病菌),紋枯病</td>
	<td>2</td>
	<td>粒剤</td>
	<td>1</td>
	<td>2008.02.06</td>
</tr>
<tr class="odd">
	<td>除草剤</td>
	<td>移植水稲</td>
	<td>フルセトスルフロン粒剤</td>
	<td>スケダチエース1キロ粒剤</td>
	<td>普</td>
	<td>2回以内</td>
	<td>移植後14日～ノビエ5葉期 但し、収穫45日前まで</td>
	<td>1kg/10a</td>
	<td></td>
	<td>湛水散布又は無人ヘリコプターによる散布</td>
	<td>フルセトスルフロン</td>
	<td>2回以内</td>
	<td>スルホニルウレア</td>
	<td>H:B</td>
	<td>ウリカワ,クログワイ,コウキヤガラ,ノビエ,ヒルムシロ,ヘラオモダカ,マツバイ</td>
	<td>1</td>
	<td>粒剤</td>
	<td>-2</td>
	<td>2015.02.04</td>
</tr>
</table>
<h2>設定項目</h2>
<dl>
<dt>■ 用途</dt>
<dd>
<p>検索対象とする用途(殺虫剤、殺菌剤、殺虫殺菌剤、除草剤のいずれか)を指定します。<em>[必須]</em></p>
</dd>
<dt>□ その他</dt>
<dd>
<p>上記以外の項目を検索条件にしたい場合、条件式を直接記述します。使用時期・使用方法などを限定したい場合や、特定の通称のみを表示したい場合などに使用します。</p>
</dd>
</dl>
<h2>設定例</h2>
<div>
<p>このテンプレートの設定例はありません。</p>
</div>
<h2>定義</h2>
<dl>
<dt>テンプレート定義</dt>
<dd><xmp id="sql">
#template {
--/d
drop table if exists tTpl;
begin transaction;
create temp table tTpl as
select distinct
  m_kihon.yoto as yoto,sakumotsu,shurui,tsusho,dokusei,kaisu,jiki,baisu,if(ekiryo='-',null,ekiryo) as ekiryo,hoho,biko,concat(',',concat(',',byochu,mokuteki)) as byochu,
  seibun1,seibun2,seibun3,seibun4,seibun5,
  kaisu1,kaisu2,kaisu3,kaisu4,kaisu5,
  keito1,keito2,keito3,keito4,keito5,
  null as rac1, null as rac2, null as rac3, null as rac4, null as rac5,
  if(dojo='-',null,dojo) as dojo,if(chitai='-',null,chitai) as chitai,if(basho='-',null,basho) as basho,ondo,jikan,kongo,zaikei,
  zenkoku as ryutsu,
  zenkoku,torokubi
from feedrice left join m_kihon using(shurui) left join m_tekiyo using(bango) left join seizai using(bango) left join idshurui using(bango) left join ryutsu using(idshurui)
where
  momi = 1 and
  bango not in (select bango from feedrice left join kihon using(shurui) where ippanmei = jogaiseibun and extnum('%', nodo) > jogainodo) and
  --ryakusho <> 'ホクサン株式会社' and
  --ryakusho <> '琉球産経株式会社' and
  m_kihon.yoto in (<yoto>) and
  --<sonota> and
  sakumotsu in (select sakumotsu from m_sakumotsu where idsaku regexp (select '^('||concat('|',substr(idsaku,1,12),substr(idsaku,1,6)||'000000',substr(idsaku,1,4)||'00000000')||')' from m_sakumotsu where sakumotsu = '移植水稲')) and
  sakumotsu not like '%苗%' and jiki not regexp '種前|種時|緑化|耕起|移植時'
group by bango,sakumotsu,jiki,baisu,ekiryo,hoho,dojo,chitai,basho,ondo,jikan;
update tTpl set kaisu1 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun1), kaisu1) where kaisu1 is not null;
update tTpl set kaisu2 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun2), kaisu2) where kaisu2 is not null;
update tTpl set kaisu3 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun3), kaisu3) where kaisu3 is not null;
update tTpl set kaisu4 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun4), kaisu4) where kaisu4 is not null;
update tTpl set kaisu5 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun5), kaisu5) where kaisu5 is not null;
update tTpl set rac1 = (select mid from rac where ippanmei = seibun1) where seibun1 is not null;
update tTpl set rac2 = (select mid from rac where ippanmei = seibun2) where seibun2 is not null;
update tTpl set rac3 = (select mid from rac where ippanmei = seibun3) where seibun3 is not null;
update tTpl set rac4 = (select mid from rac where ippanmei = seibun4) where seibun4 is not null;
update tTpl set rac5 = (select mid from rac where ippanmei = seibun5) where seibun5 is not null;
commit;
select
  yoto,sakumotsu,shurui,tsusho,dokusei,kaisu,jiki,baisu,ekiryo,hoho,biko,
  seibun1,kaisu1,keito1,rac1,
  seibun2,kaisu2,keito2,rac2,
  seibun3,kaisu3,keito3,rac3,
  seibun4,kaisu4,keito4,rac4,
  seibun5,kaisu5,keito5,rac5,
  --concat2(x'1d0d', seibun1, seibun2, seibun3, seibun4, seibun5) as ippanmei,
  --concat2(x'1d0d', kaisu1, kaisu2, kaisu3, kaisu4, kaisu5) as 使用回数,
  --concat2(x'1d0d', keito1, keito2, keito3, keito4, keito5) as keito,
  --concat2(x'1d0d', rac1, rac2, rac3, rac4, rac5) as mid,
  --concat2(x'1f0d', if(seibun2 is null, '', '1.')||seibun1, '2.'||seibun2, '3.'||seibun3, '4.'||seibun4, '5.'||seibun5) as ippanmei,
  --concat2(x'1f0d', if(kaisu2 is null, '', '1.')||kaisu1, '2.'||kaisu2, '3.'||kaisu3, '4.'||kaisu4, '5.'||kaisu5) as 使用回数,
  --concat2(x'1f0d', if(keito2 is null, '', '1.')||keito1, '2.'||keito2, '3.'||keito3, '4.'||keito4, '5.'||keito5) as keito,
  --concat2(x'1f0d', if(rac2 is null, '', '1.')||rac1, '2.'||rac2, '3.'||rac3, '4.'||rac4, '5.'||rac5) as mid,
  byochu,dojo,chitai,basho,ondo,jikan,kongo,zaikei,
  if(zenkoku, ryutsu, ifnull(zenkoku, -1) - 1) as 流通,
  min(torokubi) as torokubi
from tTpl
group by tsusho,sakumotsu,jiki,baisu,ekiryo,hoho,byochu,dojo,chitai,basho,ondo,jikan
order by yoto, tsusho;
}
</xmp></dd>
<dt>デフォルト定義</dt>
<dd><pre>
#default {
}
</pre></dd>
</dl>
</body>
</html>
