<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<meta name="Author" content="OhYeah!">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="IE=Edge">
<link rel="stylesheet" href="template.css" type="text/css">
<title>ACFinder Template</title>
<script type="text/javascript" src="template.js"></script>
<script type="text/javascript">
function opt1() {
  var cbox =
  '<li>栽培様式<select name="O1" onChange="SelMethod()">'+
  '<option value="transplant">移植'+
  '<option value="waterseeding">湛水直播'+
  '<option value="dryseeding">乾田直播'+
  '</select><div class="balloon">'+
  '<p>「移植」「湛水直播」「乾田直播」から選択すると、それぞれの栽培様式で使用可能な農薬の一覧表を作成します。</p>'+
  '<span class="arrow"><span class="inarrow"></span></span>'+
  "</div></li>\r\n";
  return cbox;
}
function opt2() {
  var cbox =
  '<li>4-HPPD阻害剤除外<select name="O2" onChange="Sel4HPPD()">'+
  '<option value="no">しない'+
  '<option value="yes">する'+
  '</select><div class="balloon">'+
  '<p>「する」を選択すると、有効成分にベンゾビシクロン等の4-HPPD阻害剤(HRAC:27)を含む農薬を検索対象から外します。'+
  '4-HPPD阻害剤高感受性品種(ルリアオバ、ミズホチカラ、モミロマン、タカナリ、オオナリ、ハバタキ、おどろきもち、兵庫牛若丸等)で使用可能な除草剤を検索する場合は、「する」を選択してください。</p>'+
  '<span class="arrow"><span class="inarrow"></span></span>'+
  "</div></li>\r\n";
  return cbox;
}
function SelMethod() {
  var n = document.F1.O1.selectedIndex;
  var ctyp = document.F1.O1.options[n].value;
  var node = document.getElementById('sql');
  if (ctyp == 'waterseeding') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/ sakumotsu in .+ = 1/, " sakumotsu in (select sakumotsu from m_sakumotsu where idsaku regexp (select '^('||concat('|',substr(idsaku,1,12),substr(idsaku,1,6)||'000000',substr(idsaku,1,4)||'00000000')||')' from m_sakumotsu where sakumotsu = '湛水直播水稲')) and sakumotsu not like '%乾田%' and hoho not like '%育苗箱%' and jiki not regexp '移植|田植|苗代|乾田' and chokuha = 1");
  } else if (ctyp == 'dryseeding') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/ sakumotsu in .+ = 1/, " sakumotsu in (select sakumotsu from m_sakumotsu where idsaku regexp (select '^('||concat('|',substr(idsaku,1,12),substr(idsaku,1,6)||'000000',substr(idsaku,1,4)||'00000000')||')' from m_sakumotsu where sakumotsu = '乾田直播水稲')) and sakumotsu not like '%湛水%' and hoho not regexp '育苗箱|種同時' and jiki not regexp '移植|田植|苗代|湛水直播' and chokuha = 1");
  } else {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/ sakumotsu in .+ = 1/, " sakumotsu in (select sakumotsu from m_sakumotsu where idsaku regexp (select '^('||concat('|',substr(idsaku,1,12),substr(idsaku,1,6)||'000000',substr(idsaku,1,4)||'00000000')||')' from m_sakumotsu where sakumotsu = '移植水稲')) and jiki not like '%直播%' and not(jiki like '%種時' and baisu like '%/10a') and ishoku = 1");
  }
}
function Sel4HPPD() {
  var n = document.F1.O2.selectedIndex;
  var ctyp = document.F1.O2.options[n].value;
  var node = document.getElementById('sql');
  if (ctyp == 'yes') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/and --bango not in/, "and bango not in");
  } else {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/and bango not in/, "and --bango not in");
  }
}
</script>
</head>
<body onload="init('',opt2(),opt1());">
<h1>飼料用(WCS)イネ使用可能農薬一覧 (2023.11.9版)</h1>
<p>特定の用途を指定すると、その用途の農薬の中から<a target="_blank" href="http://www.maff.go.jp/j/chikusan/sinko/lin/l_siryo/#wcs">稲発酵粗飼料用稲に係る農薬使用について(農林水産省生産局畜産部飼料課長通知)</a>により改訂された稲発酵粗飼料生産・給与技術マニュアルに基づいて稲発酵粗飼料(WCS)用イネで使用可能な剤を検索して、下記のような一覧表を作成します。</p>
<p>使用可能農薬の根拠となる通知の日付・発番は、SQLタブで「WCS通知.qry」を読み込んで実行すると確認できます。</p>
<p>なお、本テンプレートでは、有効成分含有量制限や剤型制限(小包装限定など)が付記された剤はその制限に抵触しない製剤のみを検索対象としますが、希釈倍数や使用方法などに制限があっても全ての適用を表示します(「地上散布に限る」場合でも無人ヘリの適用を表示)。
このため、<em>備考欄に希釈倍数・使用方法の制限が記載されている剤については、適合しない適用の行を手動で削除する</em>必要があります。</p>
<form name="F1" action="#" id="cbox"></form>
<table border="1" id="tcol">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>本剤の使用回数</th>
	<th>使用時期</th>
	<th>希釈倍数使用量</th>
	<th>散布液量</th>
	<th>使用方法</th>
	<th>備考</th>
	<th>成分1</th>
	<th>回数1</th>
	<th>系統1</th>
	<th>RAC1</th>
	<th>成分2</th>
	<th>回数2</th>
	<th>系統2</th>
	<th>RAC2</th>
	<th>適用病害虫雑草名</th>
	<th>混合</th>
	<th>剤型</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺虫剤</td>
	<td>稲</td>
	<td>燐酸第二鉄粒剤</td>
	<td>スクミンブルー</td>
	<td>普</td>
	<td>-</td>
	<td>発生時</td>
	<td>2～4kg/10a</td>
	<td></td>
	<td>散布</td>
	<td></td>
	<td>燐酸第二鉄</td>
	<td>-</td>
	<td>その他</td>
	<td>I:UN</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>スクミリンゴガイ</td>
	<td>1</td>
	<td>粒剤</td>
	<td>-2</td>
	<td>2016.10.19</td>
</tr>
<tr class="even">
	<td>除草剤</td>
	<td>水田作物</td>
	<td>グルホシネート液剤</td>
	<td>バスタ液剤</td>
	<td>普</td>
	<td>1回</td>
	<td>耕起15日前まで(雑草生育期)</td>
	<td>300～500mL/10a</td>
	<td>100～150L/10a</td>
	<td>雑草茎葉散布</td>
	<td></td>
	<td>グルホシネート</td>
	<td>グルホシネート(P): 1回</td>
	<td>アミノ酸</td>
	<td>H:H</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>一年生雑草</td>
	<td>1</td>
	<td>液剤</td>
	<td>1</td>
	<td>2002.11.12</td>
</tr>
<tr class="odd">
	<td>除草剤</td>
	<td>移植水稲</td>
	<td>オキサジクロメホン・ピリミスルファン粒剤</td>
	<td>マイウェイゼロ1キロ粒剤</td>
	<td>普</td>
	<td>1回</td>
	<td>移植直後～ノビエ2葉期 但し、移植後30日まで</td>
	<td>1kg/10a</td>
	<td></td>
	<td>湛水散布</td>
	<td>有効成分含有量がオキサジクロメホン0.6％（以下）の農薬に限る</td>
	<td>オキサジクロメホン</td>
	<td>2回以内</td>
	<td>その他</td>
	<td>H:Z</td>
	<td>ピリミスルファン</td>
	<td>2回以内</td>
	<td>スルホンアニリド</td>
	<td>H:B</td>
	<td>ウリカワ,セリ,ヒルムシロ,ヘラオモダカ(北海道、東北),ホタルイ,マツバイ,ミズガヤツリ(北海道を除く),水田一年生雑草</td>
	<td>2</td>
	<td>粒剤</td>
	<td>1</td>
	<td>2010.11.09</td>
</tr>
</table>
<table border="1" id="trow">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>本剤の使用回数</th>
	<th>使用時期</th>
	<th>希釈倍数使用量</th>
	<th>散布液量</th>
	<th>使用方法</th>
	<th>備考</th>
	<th>有効成分</th>
	<th>使用回数</th>
	<th>系統名</th>
	<th>RACコード</th>
	<th>適用病害虫雑草名</th>
	<th>混合</th>
	<th>剤型</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺虫剤</td>
	<td>稲</td>
	<td>燐酸第二鉄粒剤</td>
	<td>スクミンブルー</td>
	<td>普</td>
	<td>-</td>
	<td>発生時</td>
	<td>2～4kg/10a</td>
	<td></td>
	<td>散布</td>
	<td></td>
	<td>燐酸第二鉄</td>
	<td>-</td>
	<td>その他</td>
	<td>I:UN</td>
	<td>スクミリンゴガイ</td>
	<td>1</td>
	<td>粒剤</td>
	<td>-2</td>
	<td>2016.10.19</td>
</tr>
<tr class="even">
	<td>除草剤</td>
	<td>水田作物</td>
	<td>グルホシネート液剤</td>
	<td>バスタ液剤</td>
	<td>普</td>
	<td>1回</td>
	<td>耕起15日前まで(雑草生育期)</td>
	<td>300～500mL/10a</td>
	<td>100～150L/10a</td>
	<td>雑草茎葉散布</td>
	<td></td>
	<td>グルホシネート</td>
	<td>グルホシネート(P): 1回</td>
	<td>アミノ酸</td>
	<td>H:H</td>
	<td>一年生雑草</td>
	<td>1</td>
	<td>液剤</td>
	<td>1</td>
	<td>2002.11.12</td>
</tr>
<tr class="odd">
	<td>除草剤</td>
	<td>移植水稲</td>
	<td>オキサジクロメホン・ピリミスルファン粒剤</td>
	<td>マイウェイゼロ1キロ粒剤</td>
	<td>普</td>
	<td>1回</td>
	<td>移植直後～ノビエ2葉期 但し、移植後30日まで</td>
	<td>1kg/10a</td>
	<td></td>
	<td>湛水散布</td>
	<td>有効成分含有量がオキサジクロメホン0.6％（以下）の農薬に限る</td>
	<td>オキサジクロメホン<br>ピリミスルファン</td>
	<td>2回以内<br>2回以内</td>
	<td>その他<br>スルホンアニリド</td>
	<td>H:Z<br>H:B</td>
	<td>ウリカワ,セリ,ヒルムシロ,ヘラオモダカ(北海道、東北),ホタルイ,マツバイ,ミズガヤツリ(北海道を除く),水田一年生雑草</td>
	<td>2</td>
	<td>粒剤</td>
	<td>1</td>
	<td>2010.11.09</td>
</tr>
</table>
<table border="1" id="tclb">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>本剤の使用回数</th>
	<th>使用時期</th>
	<th>希釈倍数使用量</th>
	<th>散布液量</th>
	<th>使用方法</th>
	<th>備考</th>
	<th>有効成分</th>
	<th>使用回数</th>
	<th>系統名</th>
	<th>RACコード</th>
	<th>適用病害虫雑草名</th>
	<th>混合</th>
	<th>剤型</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺虫剤</td>
	<td>稲</td>
	<td>燐酸第二鉄粒剤</td>
	<td>スクミンブルー</td>
	<td>普</td>
	<td>-</td>
	<td>発生時</td>
	<td>2～4kg/10a</td>
	<td></td>
	<td>散布</td>
	<td></td>
	<td>燐酸第二鉄</td>
	<td>-</td>
	<td>その他</td>
	<td>I:UN</td>
	<td>スクミリンゴガイ</td>
	<td>1</td>
	<td>粒剤</td>
	<td>-2</td>
	<td>2016.10.19</td>
</tr>
<tr class="even">
	<td>除草剤</td>
	<td>水田作物</td>
	<td>グルホシネート液剤</td>
	<td>バスタ液剤</td>
	<td>普</td>
	<td>1回</td>
	<td>耕起15日前まで(雑草生育期)</td>
	<td>300～500mL/10a</td>
	<td>100～150L/10a</td>
	<td>雑草茎葉散布</td>
	<td></td>
	<td>グルホシネート</td>
	<td>グルホシネート(P): 1回</td>
	<td>アミノ酸</td>
	<td>H:H</td>
	<td>一年生雑草</td>
	<td>1</td>
	<td>液剤</td>
	<td>1</td>
	<td>2002.11.12</td>
</tr>
<tr class="odd">
	<td>除草剤</td>
	<td>移植水稲</td>
	<td>オキサジクロメホン・ピリミスルファン粒剤</td>
	<td>マイウェイゼロ1キロ粒剤</td>
	<td>普</td>
	<td>1回</td>
	<td>移植直後～ノビエ2葉期 但し、移植後30日まで</td>
	<td>1kg/10a</td>
	<td></td>
	<td>湛水散布</td>
	<td>有効成分含有量がオキサジクロメホン0.6％（以下）の農薬に限る</td>
	<td>1 オキサジクロメホン<br>2 ピリミスルファン</td>
	<td>1 2回以内<br>2 2回以内</td>
	<td>1 その他<br>2 スルホンアニリド</td>
	<td>1 H:Z<br>2 H:B</td>
	<td>ウリカワ,セリ,ヒルムシロ,ヘラオモダカ(北海道、東北),ホタルイ,マツバイ,ミズガヤツリ(北海道を除く),水田一年生雑草</td>
	<td>2</td>
	<td>粒剤</td>
	<td>1</td>
	<td>2010.11.09</td>
</tr>
</table>
<h2>設定項目</h2>
<dl>
<dt>■ 用途</dt>
<dd>
<p>検索対象とする用途(殺虫剤、殺菌剤、殺虫殺菌剤、農薬肥料、植物成長調整剤、除草剤のいずれか)を指定します。<em>[必須]</em></p>
<p>複数指定可能ですが、全て選択すると検索に時間がかかるので、「殺虫剤」と「殺虫殺菌剤」のように関連する用途のみを指定した方が良いでしょう。</p>
</dd>
<dt>□ その他</dt>
<dd>
<p>上記以外の項目を検索条件にしたい場合、条件式を直接記述します。使用時期・使用方法などを限定したい場合や、特定の通称のみを表示したい場合などに使用します。</p>
</dd>
</dl>
<h2>設定例</h2>
<div>
<p><span class="button">設定読込</span>ボタンをクリックして、下記ファイルを選択してください。この設定例を実行する際は、必ず「栽培様式」で「移植」を選択してください。</p>
<pre>
飼料用イネ箱施薬粒剤(ウンカ類対象).arg
</pre>
</div>
<h2>定義</h2>
<dl>
<dt>テンプレート定義</dt>
<dd><xmp id="sql">
#template {
--/d
drop table if exists tTpl;
begin transaction;
create temp table tTpl as
select distinct
  m_kihon.yoto as yoto,sakumotsu,shurui,tsusho,dokusei,kaisu,jiki,baisu,if(ekiryo='-',null,ekiryo) as ekiryo,hoho,biko,concat(',',concat(',',byochu,mokuteki)) as byochu,
  seibun1,seibun2,seibun3,seibun4,seibun5,
  kaisu1,kaisu2,kaisu3,kaisu4,kaisu5,
  keito1,keito2,keito3,keito4,keito5,
  null as rac1, null as rac2, null as rac3, null as rac4, null as rac5,
  if(dojo='-',null,dojo) as dojo,if(chitai='-',null,chitai) as chitai,if(basho='-',null,basho) as basho,ondo,jikan,kongo,zaikei,
  zenkoku as ryutsu,
  zenkoku,torokubi
from feedrice left join m_kihon using(shurui) left join m_tekiyo using(bango) left join seizai using(bango) left join idshurui using(bango) left join ryutsu using(idshurui)
where
  ine = 1 and --bango not in (select bango from feedrice left join kihon using(shurui) where mid like '%H:27%') and
  bango not in (select bango from feedrice left join kihon using(shurui) where ippanmei = jogaiseibun and extnum('%', nodo) > jogainodo) and
  (ifnull(biko,'') not like '%小包装%' or baisu like '%小包装%') and
  --(ifnull(biko,'') not like '%フロアブル%' or tsusho like '%フロアブル%') and
  --ryakusho <> 'ホクサン株式会社' and
  --ryakusho <> '琉球産経株式会社' and
  m_kihon.yoto in (<yoto>) and
  --<sonota> and
  sakumotsu in (select sakumotsu from m_sakumotsu where idsaku regexp (select '^('||concat('|',substr(idsaku,1,12),substr(idsaku,1,6)||'000000',substr(idsaku,1,4)||'00000000')||')' from m_sakumotsu where sakumotsu = '移植水稲')) and jiki not like '%直播%' and not(jiki like '%種時' and baisu like '%/10a') and ishoku = 1
group by bango,sakumotsu,jiki,baisu,ekiryo,hoho,dojo,chitai,basho,ondo,jikan;
update tTpl set kaisu1 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun1), kaisu1) where kaisu1 is not null;
update tTpl set kaisu2 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun2), kaisu2) where kaisu2 is not null;
update tTpl set kaisu3 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun3), kaisu3) where kaisu3 is not null;
update tTpl set kaisu4 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun4), kaisu4) where kaisu4 is not null;
update tTpl set kaisu5 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun5), kaisu5) where kaisu5 is not null;
update tTpl set rac1 = (select mid from rac where ippanmei = seibun1) where seibun1 is not null;
update tTpl set rac2 = (select mid from rac where ippanmei = seibun2) where seibun2 is not null;
update tTpl set rac3 = (select mid from rac where ippanmei = seibun3) where seibun3 is not null;
update tTpl set rac4 = (select mid from rac where ippanmei = seibun4) where seibun4 is not null;
update tTpl set rac5 = (select mid from rac where ippanmei = seibun5) where seibun5 is not null;
commit;
select
  yoto,sakumotsu,shurui,tsusho,dokusei,kaisu,jiki,baisu,ekiryo,hoho,biko,
  seibun1,kaisu1,keito1,rac1,
  seibun2,kaisu2,keito2,rac2,
  seibun3,kaisu3,keito3,rac3,
  seibun4,kaisu4,keito4,rac4,
  seibun5,kaisu5,keito5,rac5,
  --concat2(x'1d0d', seibun1, seibun2, seibun3, seibun4, seibun5) as ippanmei,
  --concat2(x'1d0d', kaisu1, kaisu2, kaisu3, kaisu4, kaisu5) as 使用回数,
  --concat2(x'1d0d', keito1, keito2, keito3, keito4, keito5) as keito,
  --concat2(x'1d0d', rac1, rac2, rac3, rac4, rac5) as mid,
  --concat2(x'1f0d', if(seibun2 is null, '', '1 ')||seibun1, '2 '||seibun2, '3 '||seibun3, '4 '||seibun4, '5 '||seibun5) as ippanmei,
  --concat2(x'1f0d', if(kaisu2 is null, '', '1 ')||kaisu1, '2 '||kaisu2, '3 '||kaisu3, '4 '||kaisu4, '5 '||kaisu5) as 使用回数,
  --concat2(x'1f0d', if(keito2 is null, '', '1 ')||keito1, '2 '||keito2, '3 '||keito3, '4 '||keito4, '5 '||keito5) as keito,
  --concat2(x'1f0d', if(rac2 is null, '', '1 ')||rac1, '2 '||rac2, '3 '||rac3, '4 '||rac4, '5 '||rac5) as mid,
  byochu,dojo,chitai,basho,ondo,jikan,kongo,zaikei,
  if(zenkoku, ryutsu, ifnull(zenkoku, -1) - 1) as 流通,
  min(torokubi) as torokubi
from tTpl
group by tsusho,sakumotsu,jiki,baisu,ekiryo,hoho,byochu,dojo,chitai,basho,ondo,jikan
order by yoto, tsusho;
}
</xmp></dd>
<dt>デフォルト定義</dt>
<dd><pre>
#default {
}
</pre></dd>
</dl>
</body>
</html>
