<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<meta name="Author" content="OhYeah!">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="IE=Edge">
<link rel="stylesheet" href="template.css" type="text/css">
<title>ACFinder Template</title>
<script type="text/javascript" src="template.js"></script>
<script type="text/javascript">
function opt1() {
  var cbox =
  '<li>展着剤等除外<select name="O1" onChange="SelSprd()">'+
  '<option value="exclude">する'+
  '<option value="include">しない'+
  '</select><div class="balloon">'+
  '<p>「する」を選択すると、展着剤や倉庫くん蒸剤を検索対象から除外します。</p>'+
  '<span class="arrow"><span class="inarrow"></span></span>'+
  "</div></li>\r\n";
  return cbox;
}
function SelSprd() {
  var n = document.F1.O1.selectedIndex;
  var ctyp = document.F1.O1.options[n].value;
  var node = document.getElementById('sql');
  if (ctyp == 'include') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/(\(shurui \<\> '展着剤')/, "--$1");
  } else {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/--(\(shurui \<\> '展着剤')/, "$1");
  }
}
</script>
</head>
<body onload="init('',autodep(),opt1());">
<h1>特定作物通称別防除記録 (2024.10.29版)</h1>
<p>特定の作物系統を指定すると、その作物系統に登録のある農薬を検索して、下記のような一覧表を作成します。
防除記録用の枠が追加されることを除くと、「特定作物農薬一覧」とほぼ同じです。</p>
<form name="F1" action="#" id="cbox"></form>
<table border="1" id="tcol">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>使用方法</th>
	<th>散布液量</th>
	<th>成分1</th>
	<th>回数1</th>
	<th>系統1</th>
	<th>RAC1</th>
	<th>成分2</th>
	<th>回数2</th>
	<th>系統2</th>
	<th>RAC2</th>
	<th>対象病害虫等</th>
	<th>対象病害虫数</th>
	<th>使用日1</th>
	<th>使用日2</th>
	<th>使用日3</th>
	<th>使用日4</th>
	<th>使用日5</th>
	<th>使用日6</th>
	<th>使用日7</th>
	<th>使用日8</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>ミニトマト</td>
	<td>炭酸水素カリウム水溶剤</td>
	<td>カリグリーン</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>-</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>炭酸水素カリウム</td>
	<td>-</td>
	<td>炭酸水素塩</td>
	<td>F:NC</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>うどんこ病 800～1000倍, さび病 800倍, 灰色かび病 800倍, 葉かび病 800倍</td>
	<td>4</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>1</td>
	<td>水溶剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1993.05.19</td>
</tr>
<tr class="even">
	<td>殺菌剤</td>
	<td>ミニトマト</td>
	<td>フェンピラザミン水和剤</td>
	<td>ピクシオDF</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>4回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>フェンピラザミン</td>
	<td>4回以内</td>
	<td>アミドピラゾリノン</td>
	<td>F:17</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>灰色かび病 2000倍, 菌核病 2000倍</td>
	<td>2</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>*</td>
	<td>*</td>
	<td>*</td>
	<td>*</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>-2</td>
	<td>2013.07.02</td>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>ミニトマト</td>
	<td>シモキサニル・ファモキサドン水和剤</td>
	<td>ホライズンドライフロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>3回以内</td>
	<td>散布</td>
	<td>150～300L/10a</td>
	<td>シモキサニル</td>
	<td>3回以内</td>
	<td>シアノアセトアミド</td>
	<td>F:27</td>
	<td>ファモキサドン</td>
	<td>3回以内</td>
	<td>オキサゾリジンジオン</td>
	<td>F:11</td>
	<td>疫病 1500～2500倍, 葉かび病 2500倍</td>
	<td>2</td>
	<td></td>
	<td></td>
	<td></td>
	<td>*</td>
	<td>*</td>
	<td>*</td>
	<td>*</td>
	<td>*</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>2000.04.28</td>
</tr>
</table>
<table border="1" id="trow">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>使用方法</th>
	<th>散布液量</th>
	<th>有効成分</th>
	<th>使用回数</th>
	<th>系統名</th>
	<th>RACコード</th>
	<th>対象病害虫等</th>
	<th>対象病害虫数</th>
	<th>使用日1</th>
	<th>使用日2</th>
	<th>使用日3</th>
	<th>使用日4</th>
	<th>使用日5</th>
	<th>使用日6</th>
	<th>使用日7</th>
	<th>使用日8</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>ミニトマト</td>
	<td>炭酸水素カリウム水溶剤</td>
	<td>カリグリーン</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>-</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>炭酸水素カリウム</td>
	<td>-</td>
	<td>炭酸水素塩</td>
	<td>F:NC</td>
	<td>うどんこ病 800～1000倍, さび病 800倍, 灰色かび病 800倍, 葉かび病 800倍</td>
	<td>4</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>1</td>
	<td>水溶剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1993.05.19</td>
</tr>
<tr class="even">
	<td>殺菌剤</td>
	<td>ミニトマト</td>
	<td>フェンピラザミン水和剤</td>
	<td>ピクシオDF</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>4回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>フェンピラザミン</td>
	<td>4回以内</td>
	<td>アミドピラゾリノン</td>
	<td>F:17</td>
	<td>灰色かび病 2000倍, 菌核病 2000倍</td>
	<td>2</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>*</td>
	<td>*</td>
	<td>*</td>
	<td>*</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>-2</td>
	<td>2013.07.02</td>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>ミニトマト</td>
	<td>シモキサニル・ファモキサドン水和剤</td>
	<td>ホライズンドライフロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>3回以内</td>
	<td>散布</td>
	<td>150～300L/10a</td>
	<td>シモキサニル<br>ファモキサドン</td>
	<td>3回以内<br>3回以内</td>
	<td>シアノアセトアミド<br>オキサゾリジンジオン</td>
	<td>F:27<br>F:11</td>
	<td>疫病 1500～2500倍, 葉かび病 2500倍</td>
	<td>2</td>
	<td></td>
	<td></td>
	<td></td>
	<td>*</td>
	<td>*</td>
	<td>*</td>
	<td>*</td>
	<td>*</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>2000.04.28</td>
</tr>
</table>
<table border="1" id="tclb">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>使用方法</th>
	<th>散布液量</th>
	<th>有効成分</th>
	<th>使用回数</th>
	<th>系統名</th>
	<th>RACコード</th>
	<th>対象病害虫等</th>
	<th>対象病害虫数</th>
	<th>使用日1</th>
	<th>使用日2</th>
	<th>使用日3</th>
	<th>使用日4</th>
	<th>使用日5</th>
	<th>使用日6</th>
	<th>使用日7</th>
	<th>使用日8</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>ミニトマト</td>
	<td>炭酸水素カリウム水溶剤</td>
	<td>カリグリーン</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>-</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>炭酸水素カリウム</td>
	<td>-</td>
	<td>炭酸水素塩</td>
	<td>F:NC</td>
	<td>うどんこ病 800～1000倍, さび病 800倍, 灰色かび病 800倍, 葉かび病 800倍</td>
	<td>4</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>1</td>
	<td>水溶剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1993.05.19</td>
</tr>
<tr class="even">
	<td>殺菌剤</td>
	<td>ミニトマト</td>
	<td>フェンピラザミン水和剤</td>
	<td>ピクシオDF</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>4回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>フェンピラザミン</td>
	<td>4回以内</td>
	<td>アミドピラゾリノン</td>
	<td>F:17</td>
	<td>灰色かび病 2000倍, 菌核病 2000倍</td>
	<td>2</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>*</td>
	<td>*</td>
	<td>*</td>
	<td>*</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>-2</td>
	<td>2013.07.02</td>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>ミニトマト</td>
	<td>シモキサニル・ファモキサドン水和剤</td>
	<td>ホライズンドライフロアブル</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>3回以内</td>
	<td>散布</td>
	<td>150～300L/10a</td>
	<td>1 シモキサニル<br>2 ファモキサドン</td>
	<td>1 3回以内<br>2 3回以内</td>
	<td>1 シアノアセトアミド<br>2 オキサゾリジンジオン</td>
	<td>1 F:27<br>2 F:11</td>
	<td>疫病 1500～2500倍, 葉かび病 2500倍</td>
	<td>2</td>
	<td></td>
	<td></td>
	<td></td>
	<td>*</td>
	<td>*</td>
	<td>*</td>
	<td>*</td>
	<td>*</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>2000.04.28</td>
</tr>
</table>
<h2>設定項目</h2>
<dl>
<dt>■ 作物名</dt>
<dd>
<p>検索対象とする作物系統を１系統のみ指定できます。<em>[必須]</em></p>
<p>「作物群一括検索」で「する」を選択した場合、作物名に「'きゅうり'」だけを指定しても「きゅうり」以外に上位作物群の「うり類(未成熟),うり科野菜類,うり類,野菜類」のほか、
下位作物群である「きゅうり(施設栽培),きゅうり(露地栽培(移植栽培)),きゅうり(露地栽培(直播栽培))」も含めて検索します。
作物名に「'きゅうり(施設栽培)'」を指定した場合は、上位作物群の「きゅうり,うり類(未成熟),うり科野菜類,うり類,野菜類」(ただし「野菜類(露地栽培)」は除く)を検索します。</p>
<p>登録農薬が多い作物で大作物群などの上位作物群まで含めて検索したくない場合は、「作物群一括検索」で「しない」を選択し、
「'きゅうり(施設野菜),きゅうり'」あるいは「'きゅうり,うり類(未成熟),うり科野菜類,うり類'」などのように遡る作物群を限定します。
作物群一括検索「しない」でも、「'きゅうり'」を指定した場合、下位作物群である「きゅうり(施設栽培),きゅうり(露地栽培(移植栽培)),きゅうり(露地栽培(直播栽培))」も含めて検索します。</p>
</dd>
<dt>□ 用途</dt>
<dd>
<p>検索対象とする用途を指定します。無指定の場合は、全ての用途を検索します。</p>
<p>複数指定可能ですが、殺虫剤一覧を作成する場合は「殺虫剤」または「殺虫剤, 殺虫殺菌剤」、殺菌剤一覧を作成する場合は「殺菌剤」または「殺菌剤, 殺虫殺菌剤」を選択すると良いでしょう。</p>
</dd>
<dt>□ 剤型</dt>
<dd>
<p>検索対象とする剤型を複数選択できます。無指定の場合は、全ての剤型を検索します。</p>
</dd>
<dt>□ その他</dt>
<dd>
<p>上記以外の項目を検索条件にしたい場合、条件式を直接記述します。使用時期・使用方法などを限定したい場合や、特定の通称のみを表示したい場合などに使用します。</p>
</dd>
</dl>
<h2>設定例</h2>
<div>
<p><span class="button">設定読込</span>ボタンをクリックして、下記ファイルを選択してください。</p>
<pre>
ミニトマト防除記録.arg
ミニトマト殺菌剤防除記録.arg
</pre>
</div>
<h2>定義</h2>
<dl>
<dt>テンプレート定義</dt>
<dd><xmp id="sql">
#template {
--/d
drop table if exists tTpl;
create temp table tTpl as
select distinct
  bango,yoto,sakumotsu,shurui,tsusho,dokusei,jiki,kaisu,hoho,
  byochu,mokuteki,baisu,ekiryo,basho,jikan,ondo,dojo,chitai,tekiyaku,
  seibun1,seibun2,seibun3,seibun4,seibun5,
  kaisu1,kaisu2,kaisu3,kaisu4,kaisu5,
  keito1,keito2,keito3,keito4,keito5,
  null as rac1, null as rac2, null as rac3, null as rac4, null as rac5,
  kongo,zaikei,koka,
  zenkoku as ryutsu,
  zenkoku,torokubi
from m_tekiyo left join m_kihon using(bango) left join seizai using(bango) left join idshurui using(bango) left join ryutsu using(idshurui)
where
  --ryakusho <> 'ホクサン株式会社' and
  --ryakusho <> '琉球産経株式会社' and
  --yoto in (<yoto>) and
  --zaikei in (<zaikei>) and
  --<sonota> and
  (shurui <> '展着剤' and concat('、', hoho, basho) not regexp '倉庫|貯蔵|気密|天幕|サイロ') and
  sakumotsu in (select sakumotsu from m_sakumotsu left join sakuhojo using(idsaku) where 
    '、'||concat('、', sakumotsu, shozoku)||'、' regexp <~sakumotsu~> and nozoku not regexp <~sakumotsu~> or fukumu regexp <~sakumotsu~>
  );
update tTpl set kaisu1 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun1), kaisu1) where kaisu1 is not null;
update tTpl set kaisu2 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun2), kaisu2) where kaisu2 is not null;
update tTpl set kaisu3 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun3), kaisu3) where kaisu3 is not null;
update tTpl set kaisu4 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun4), kaisu4) where kaisu4 is not null;
update tTpl set kaisu5 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun5), kaisu5) where kaisu5 is not null;
update tTpl set rac1 = (select mid from rac where ippanmei = seibun1) where seibun1 is not null;
update tTpl set rac2 = (select mid from rac where ippanmei = seibun2) where seibun2 is not null;
update tTpl set rac3 = (select mid from rac where ippanmei = seibun3) where seibun3 is not null;
update tTpl set rac4 = (select mid from rac where ippanmei = seibun4) where seibun4 is not null;
update tTpl set rac5 = (select mid from rac where ippanmei = seibun5) where seibun5 is not null;
select
  yoto,sakumotsu,shurui,tsusho,dokusei,jiki,kaisu,hoho,
  max(ekiryo) as ekiryo,
  seibun1,kaisu1,keito1,rac1,
  seibun2,kaisu2,keito2,rac2,
  seibun3,kaisu3,keito3,rac3,
  seibun4,kaisu4,keito4,rac4,
  seibun5,kaisu5,keito5,rac5,
  --concat2(x'1d0d', seibun1, seibun2, seibun3, seibun4, seibun5) as ippanmei,
  --concat2(x'1d0d', kaisu1, kaisu2, kaisu3, kaisu4, kaisu5) as 使用回数,
  --concat2(x'1d0d', keito1, keito2, keito3, keito4, keito5) as keito,
  --concat2(x'1d0d', rac1, rac2, rac3, rac4, rac5) as mid,
  --concat2(x'1f0d', if(seibun2 is null, '', '1 ')||seibun1, '2 '||seibun2, '3 '||seibun3, '4 '||seibun4, '5 '||seibun5) as ippanmei,
  --concat2(x'1f0d', if(kaisu2 is null, '', '1 ')||kaisu1, '2 '||kaisu2, '3 '||kaisu3, '4 '||kaisu4, '5 '||kaisu5) as 使用回数,
  --concat2(x'1f0d', if(keito2 is null, '', '1 ')||keito1, '2 '||keito2, '3 '||keito3, '4 '||keito4, '5 '||keito5) as keito,
  --concat2(x'1f0d', if(rac2 is null, '', '1 ')||rac1, '2 '||rac2, '3 '||rac3, '4 '||rac4, '5 '||rac5) as mid,
  concat(', ', concat('', byochu, mokuteki, ' ', baisu)) as 対象病害虫等,
  count(distinct concat('', byochu, mokuteki)) as 対象病害虫数,
  ' ' as 使用日1,
  case when extnum('回', kaisu, 10) < 2 then '*' else ' ' end as 使用日2,
  case when extnum('回', kaisu, 10) < 3 then '*' else ' ' end as 使用日3,
  case when extnum('回', kaisu, 10) < 4 then '*' else ' ' end as 使用日4,
  case when extnum('回', kaisu, 10) < 5 then '*' else ' ' end as 使用日5,
  case when extnum('回', kaisu, 10) < 6 then '*' else ' ' end as 使用日6,
  case when extnum('回', kaisu, 10) < 7 then '*' else ' ' end as 使用日7,
  case when extnum('回', kaisu, 10) < 8 then '*' else ' ' end as 使用日8,
  kongo,zaikei,koka,
  if(zenkoku, ryutsu, ifnull(zenkoku, -1) - 1) as 流通,
  min(torokubi) as torokubi
from tTpl
group by sakumotsu, tsusho, dokusei, kaisu, jiki, hoho, basho, jikan, ondo, chitai, tekiyaku
order by yoto, tsusho;
}
</xmp></dd>
<dt>デフォルト定義</dt>
<dd><pre>
#default {
}
</pre></dd>
</dl>
</body>
</html>
