<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<meta name="Author" content="OhYeah!">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="IE=Edge">
<link rel="stylesheet" href="template.css" type="text/css">
<title>ACFinder Template</title>
<script type="text/javascript" src="template.js"></script>
</head>
<body onload="init('',ExcSprd());">
<h1>特定作物群内全農薬一覧 (2024.10.29版)</h1>
<p>特定の作物群(中作物群以下)を指定すると、その作物群に含まれる全ての作物に登録のある農薬を検索して、下記のような一覧表を作成します。
「指定作物農薬一覧」の特定作物群内全作物対応版です。</p>
<form name="F1" action="#" id="cbox"></form>
<table border="1" id="tcol">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>使用方法</th>
	<th>散布液量</th>
	<th>成分1</th>
	<th>回数1</th>
	<th>系統1</th>
	<th>RAC1</th>
	<th>成分2</th>
	<th>回数2</th>
	<th>系統2</th>
	<th>RAC2</th>
	<th>対象病害虫等</th>
	<th>対象病害虫数</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>大麦</td>
	<td>テブコナゾール水和剤</td>
	<td>シルバキュアフロアブル</td>
	<td>普</td>
	<td>収穫14日前まで</td>
	<td>3回以内</td>
	<td>散布</td>
	<td>60～150L/10a</td>
	<td>テブコナゾール</td>
	<td>2回以内</td>
	<td>EBI</td>
	<td>F:3</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>赤かび病 2000倍</td>
	<td>1</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1992.12.10</td>
</tr>
<tr class="even">
	<td>殺菌剤</td>
	<td>小麦</td>
	<td>テブコナゾール水和剤</td>
	<td>シルバキュアフロアブル</td>
	<td>普</td>
	<td>収穫7日前まで</td>
	<td>2回以内</td>
	<td>散布</td>
	<td>60～150L/10a</td>
	<td>テブコナゾール</td>
	<td>2回以内</td>
	<td>EBI</td>
	<td>F:3</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>赤かび病 2000倍</td>
	<td>1</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1992.12.10</td>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>麦類(小麦を除く)</td>
	<td>イミノクタジン酢酸塩・チオファネートメチル水和剤</td>
	<td>ベフトップジンフロアブル</td>
	<td>劇</td>
	<td>収穫14日前まで</td>
	<td>2回以内(出穂期以降は1回以内)</td>
	<td>散布</td>
	<td>60～180L/10a</td>
	<td>イミノクタジン酢酸塩</td>
	<td>イミノクタジン: 3回以内(種子への処理は1回以内、散布は2回以内、出穂期以降は1回以内)</td>
	<td>グアニジン</td>
	<td>F:M07</td>
	<td>チオファネートメチル</td>
	<td>3回以内(種子への処理は1回以内、出穂期以降は1回以内)</td>
	<td>ベンズイミダゾール</td>
	<td>F:1</td>
	<td>赤かび病 1000倍</td>
	<td>1</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>2006.12.27</td>
</tr>
</table>
<table border="1" id="trow">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>使用方法</th>
	<th>散布液量</th>
	<th>有効成分</th>
	<th>使用回数</th>
	<th>系統名</th>
	<th>RACコード</th>
	<th>対象病害虫等</th>
	<th>対象病害虫数</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>大麦</td>
	<td>テブコナゾール水和剤</td>
	<td>シルバキュアフロアブル</td>
	<td>普</td>
	<td>収穫14日前まで</td>
	<td>3回以内</td>
	<td>散布</td>
	<td>60～150L/10a</td>
	<td>テブコナゾール</td>
	<td>2回以内</td>
	<td>EBI</td>
	<td>F:3</td>
	<td>赤かび病 2000倍</td>
	<td>1</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1992.12.10</td>
</tr>
<tr class="even">
	<td>殺菌剤</td>
	<td>小麦</td>
	<td>テブコナゾール水和剤</td>
	<td>シルバキュアフロアブル</td>
	<td>普</td>
	<td>収穫7日前まで</td>
	<td>2回以内</td>
	<td>散布</td>
	<td>60～150L/10a</td>
	<td>テブコナゾール</td>
	<td>2回以内</td>
	<td>EBI</td>
	<td>F:3</td>
	<td>赤かび病 2000倍</td>
	<td>1</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1992.12.10</td>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>麦類(小麦を除く)</td>
	<td>イミノクタジン酢酸塩・チオファネートメチル水和剤</td>
	<td>ベフトップジンフロアブル</td>
	<td>劇</td>
	<td>収穫14日前まで</td>
	<td>2回以内(出穂期以降は1回以内)</td>
	<td>散布</td>
	<td>60～180L/10a</td>
	<td>イミノクタジン酢酸塩<br>チオファネートメチル</td>
	<td>イミノクタジン: 3回以内(種子への処理は1回以内、散布は2回以内、出穂期以降は1回以内)<br>3回以内(種子への処理は1回以内、出穂期以降は1回以内)</td>
	<td>グアニジン<br>ベンズイミダゾール</td>
	<td>F:M07<br>F:1</td>
	<td>赤かび病 1000倍</td>
	<td>1</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>2006.12.27</td>
</tr>
</table>
<table border="1" id="tclb">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>使用方法</th>
	<th>散布液量</th>
	<th>有効成分</th>
	<th>使用回数</th>
	<th>系統名</th>
	<th>RACコード</th>
	<th>対象病害虫等</th>
	<th>対象病害虫数</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>大麦</td>
	<td>テブコナゾール水和剤</td>
	<td>シルバキュアフロアブル</td>
	<td>普</td>
	<td>収穫14日前まで</td>
	<td>3回以内</td>
	<td>散布</td>
	<td>60～150L/10a</td>
	<td>テブコナゾール</td>
	<td>2回以内</td>
	<td>EBI</td>
	<td>F:3</td>
	<td>赤かび病 2000倍</td>
	<td>1</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1992.12.10</td>
</tr>
<tr class="even">
	<td>殺菌剤</td>
	<td>小麦</td>
	<td>テブコナゾール水和剤</td>
	<td>シルバキュアフロアブル</td>
	<td>普</td>
	<td>収穫7日前まで</td>
	<td>2回以内</td>
	<td>散布</td>
	<td>60～150L/10a</td>
	<td>テブコナゾール</td>
	<td>2回以内</td>
	<td>EBI</td>
	<td>F:3</td>
	<td>赤かび病 2000倍</td>
	<td>1</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1992.12.10</td>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>麦類(小麦を除く)</td>
	<td>イミノクタジン酢酸塩・チオファネートメチル水和剤</td>
	<td>ベフトップジンフロアブル</td>
	<td>劇</td>
	<td>収穫14日前まで</td>
	<td>2回以内(出穂期以降は1回以内)</td>
	<td>散布</td>
	<td>60～180L/10a</td>
	<td>1 イミノクタジン酢酸塩<br>2 チオファネートメチル</td>
	<td>1 イミノクタジン: 3回以内(種子への処理は1回以内、散布は2回以内、出穂期以降は1回以内)<br>2 3回以内(種子への処理は1回以内、出穂期以降は1回以内)</td>
	<td>1 グアニジン<br>2 ベンズイミダゾール</td>
	<td>1 F:M07<br>2 F:1</td>
	<td>赤かび病 1000倍</td>
	<td>1</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>2006.12.27</td>
</tr>
</table>
<h2>設定項目</h2>
<dl>
<dt>■ 作物名</dt>
<dd>
<p>検索対象とする作物系統を１系統のみ指定できます。<em>[必須]</em></p>
<p>作物系統の先頭で先頭で指定した作物群については、自動的に下位の作物群も検索対象とします。先頭に指定できる作物群は中作物群以下で、「野菜類」等の大作物群は指定できません。</p>
<P>たとえば、「'ピーマン及びとうがらし類,なす科果菜類,野菜類'」のように指定すると、列挙された作物群だけでなく、
先頭の「ピーマン及びとうがらし類」の下位作物群である「ピーマン,とうがらし類,とうがらし類(施設栽培),甘長とうがらし,ししとう,ししとう(施設栽培),ハバネロ」も含めて検索します。
「野菜類」などの上位作物群を検索対象としたくない場合は、「'ピーマン及びとうがらし類,なす科果菜類'」のように検索対象とする上位作物群を限定してください。</p>
</dd>
<dt>□ 病害虫</dt>
<dd>
<p>検索対象とする病害虫・雑草を指定します(複数指定可)。無指定の場合は、全ての病害虫・雑草を検索します。</p>
<p>「その他」の設定と併用して、「無人航空機」で使用可能な「赤かび病」の薬剤を検索したい場合などに使用します。</p>
</dd>
<dt>□ 用途</dt>
<dd>
<p>検索対象とする用途を指定します(複数指定可)。無指定の場合は、全ての用途を検索します。</p>
<p>複数指定可能ですが、殺虫剤一覧を作成する場合は「殺虫剤」または「殺虫剤, 殺虫殺菌剤」、殺菌剤一覧を作成する場合は「殺菌剤」または「殺菌剤, 殺虫殺菌剤」を選択すると良いでしょう。</p>
</dd>
<dt>□ 剤型</dt>
<dd>
<p>検索対象とする剤型を指定します(複数指定可)。無指定の場合は、全ての剤型を検索します。</p>
<p>希釈散布剤だけを検索したい場合は、「希釈散布剤.arg」を読み込んでください。</p>
</dd>
<dt>□ その他</dt>
<dd>
<p>上記以外の項目を検索条件にしたい場合、条件式を直接記述します。使用時期・使用方法などを限定したい場合や、特定の通称のみを表示したい場合などに使用します。</p>
<p>収穫期に使用可能な散布剤だけを検索したい場合は、「収穫期散布剤.arg」を読み込んでください。</p>
<p>無人航空機、水口施用、投げ込み、常温煙霧に対応する薬剤を検索したい場合は、それぞれ「無人航空機.arg」「水口施用.arg」「投げ込み.arg」「常温煙霧.arg」を読み込んでください。</p>
</dd>
</dl>
<h2>設定例</h2>
<div>
<p><span class="button">設定読込</span>ボタンをクリックして、下記ファイルを選択してください。</p>
<pre>
麦類赤かび病作物群内全農薬一覧.arg
</pre>
</div>
<h2>定義</h2>
<dl>
<dt>テンプレート定義</dt>
<dd><xmp id="sql">
#template {
--/d
drop table if exists tTpl;
create temp table tTpl as
select distinct
  bango,yoto,sakumotsu,shurui,tsusho,dokusei,jiki,kaisu,hoho,
  byochu,mokuteki,baisu,ekiryo,basho,jikan,ondo,dojo,chitai,tekiyaku,
  seibun1,seibun2,seibun3,seibun4,seibun5,
  kaisu1,kaisu2,kaisu3,kaisu4,kaisu5,
  keito1,keito2,keito3,keito4,keito5,
  null as rac1, null as rac2, null as rac3, null as rac4, null as rac5,
  kongo,zaikei,koka,
  zenkoku as ryutsu,
  zenkoku,torokubi
from m_tekiyo left join m_kihon using(bango) left join seizai using(bango) left join idshurui using(bango) left join ryutsu using(idshurui)
where
  --ryakusho <> 'ホクサン株式会社' and
  --ryakusho <> '琉球産経株式会社' and
  --byochu in (<byochu>) and
  --yoto in (<yoto>) and
  --zaikei in (<zaikei>) and
  --<sonota> and
  (shurui <> '展着剤' and concat('、', hoho, basho) not regexp '倉庫|貯蔵|気密|天幕|サイロ') and
  sakumotsu in (select sakumotsu from m_sakumotsu left join sakuhojo using(idsaku) where 
    '、'||concat('、', sakumotsu, shozoku)||'、' regexp <_sakumotsu_> and nozoku not regexp <:sakumotsu:> or fukumu regexp <_sakumotsu_>
  );
update tTpl set kaisu1 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun1), kaisu1) where kaisu1 is not null;
update tTpl set kaisu2 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun2), kaisu2) where kaisu2 is not null;
update tTpl set kaisu3 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun3), kaisu3) where kaisu3 is not null;
update tTpl set kaisu4 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun4), kaisu4) where kaisu4 is not null;
update tTpl set kaisu5 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun5), kaisu5) where kaisu5 is not null;
update tTpl set rac1 = (select mid from rac where ippanmei = seibun1) where seibun1 is not null;
update tTpl set rac2 = (select mid from rac where ippanmei = seibun2) where seibun2 is not null;
update tTpl set rac3 = (select mid from rac where ippanmei = seibun3) where seibun3 is not null;
update tTpl set rac4 = (select mid from rac where ippanmei = seibun4) where seibun4 is not null;
update tTpl set rac5 = (select mid from rac where ippanmei = seibun5) where seibun5 is not null;
select
  yoto,sakumotsu,shurui,tsusho,dokusei,jiki,kaisu,hoho,ekiryo,
  basho,jikan,ondo,dojo,chitai,tekiyaku,
  seibun1,kaisu1,keito1,rac1,
  seibun2,kaisu2,keito2,rac2,
  seibun3,kaisu3,keito3,rac3,
  seibun4,kaisu4,keito4,rac4,
  seibun5,kaisu5,keito5,rac5,
  --concat2(x'1d0d', seibun1, seibun2, seibun3, seibun4, seibun5) as ippanmei,
  --concat2(x'1d0d', kaisu1, kaisu2, kaisu3, kaisu4, kaisu5) as 使用回数,
  --concat2(x'1d0d', keito1, keito2, keito3, keito4, keito5) as keito,
  --concat2(x'1d0d', rac1, rac2, rac3, rac4, rac5) as mid,
  --concat2(x'1f0d', if(seibun2 is null, '', '1 ')||seibun1, '2 '||seibun2, '3 '||seibun3, '4 '||seibun4, '5 '||seibun5) as ippanmei,
  --concat2(x'1f0d', if(kaisu2 is null, '', '1 ')||kaisu1, '2 '||kaisu2, '3 '||kaisu3, '4 '||kaisu4, '5 '||kaisu5) as 使用回数,
  --concat2(x'1f0d', if(keito2 is null, '', '1 ')||keito1, '2 '||keito2, '3 '||keito3, '4 '||keito4, '5 '||keito5) as keito,
  --concat2(x'1f0d', if(rac2 is null, '', '1 ')||rac1, '2 '||rac2, '3 '||rac3, '4 '||rac4, '5 '||rac5) as mid,
  concat(', ', concat('', byochu, mokuteki, ' ', baisu)) as 対象病害虫等,
  count(distinct concat('', byochu, mokuteki)) as 対象病害虫数,
  kongo,zaikei,koka,
  if(zenkoku, ryutsu, ifnull(zenkoku, -1) - 1) as 流通,
  min(torokubi) as torokubi
from tTpl
group by sakumotsu, tsusho, dokusei, kaisu, jiki, hoho, ekiryo, basho, jikan, ondo, chitai, tekiyaku
order by yoto, tsusho;
}
</xmp></dd>
<dt>デフォルト定義</dt>
<dd><pre>
#default {
}
</pre></dd>
</dl>
</body>
</html>
