<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<meta name="Author" content="OhYeah!">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="IE=Edge">
<link rel="stylesheet" href="template.css" type="text/css">
<title>ACFinder Template</title>
<script type="text/javascript" src="template.js"></script>
<script type="text/javascript">
function opt1() {
  var cbox =
  '<li>認証区分<select name="O1" onChange="SelCat()">'+
  '<option value="organic">有機JAS'+
  '<option value="special">特別栽培'+
  '</select><div class="balloon">'+
  '<p>「有機JAS」を選択すると、有機JAS表B.1に記載された農薬の一覧表を作成します。'+
  '「特別栽培」を選択すると、有機JAS表B.1及び化学合成されていない農薬の一覧表を作成します。</p>'+
  '<span class="arrow"><span class="inarrow"></span></span>'+
  "</div></li>\r\n";
  return cbox;
}
function SelCat() {
  var n = document.F1.O1.selectedIndex;
  var ctyp = document.F1.O1.options[n].value;
  var node = document.getElementById('sql');
  if (ctyp == 'organic') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/ or shurui in/, ' --or shurui in');
  } else {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/ --or shurui in/, ' or shurui in');
  }
}
</script>
</head>
<body onload="init('',autodep(),opt1());">
<h1>特定作物有機JAS表B1・特別栽培無カウント農薬一覧 (2024.10.29版)</h1>
<p>特定の作物系統を指定すると、その作物系統に登録のある農薬の中から<a target="_blank" href="http://www.maff.go.jp/j/jas/jas_kikaku/yuuki.html">「有機農産物の日本農林規格(有機JAS)」(農林水産省告示)</a>の表B.1や特別栽培農産物でカウントしない剤を検索して、下記のような一覧表を作成します。</p>
<p>使用可能農薬の根拠となる告示の日付・番号は、SQLタブで「有機JAS告示.qry」を読み込んで実行すると確認できます。</p>
<p>表B.1に記載された農薬のうち、下記の農薬については基準が定められています。
本テンプレートでは農薬の種類として該当するものは全て検索しますので、<em>各剤が有機JASで使用可能かどうかはラベル表記または農薬メーカーにご確認ください。</em><br>
(1) 全ての農薬<br>
　組換え DNA 技術を用いて製造されていないものに限る。(黄色ラベルのエコピタ液剤はこの理由で非適合)<br>
(2) 除虫菊乳剤及びピレトリン乳剤<br>
　除虫菊から抽出したものであって、共力剤としてピペロニルブトキサイドを含まないものに限ること。<br>
(3) メタアルデヒド粒剤<br>
　捕虫器に使用する場合に限ること。<br>
(4) 硫酸銅及び生石灰<br>
　ボルドー剤調製用に使用する場合に限ること。<br>
(5) 性フェロモン剤<br>
　農作物を害する昆虫のフェロモン作用を有する物質を有効成分とするものに限ること。<br>
(6) 展着剤(カゼインを有効成分とするものは全て失効しているため、本テンプレートの検索対象外)<br>
　カゼイン又はパラフィンを有効成分とするものに限ること。<br>
(7) 二酸化炭素くん蒸剤及びケイソウ土粉剤<br>
　保管施設で使用する場合に限ること。<br>
(8) 炭酸カルシウム水和剤<br>
　銅水和剤の薬害防止に使用する場合に限ること。<br>
(9) エチレン(適用範囲が狭すぎるので、本テンプレートの検索対象外)<br>
　パイナップルの開花誘発に使用する場合に限ること。</p>
<p>特別栽培については、同一製剤でも認証団体によって化学農薬としてカウントされたりされなかったりということがあります。
また、同じ有効成分でも剤型によっては化学合成されていたり、同じ製品名でも有効成分が天然物であったり化学合成物であったりします。
<em>リストアップされた農薬の使用に当たっては、必ずそれぞれの認証団体にカウントの有無をご確認ください。</em></p>
<form name="F1" action="#" id="cbox"></form>
<table border="1" id="tcol">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>使用方法</th>
	<th>散布液量</th>
	<th>成分1</th>
	<th>回数1</th>
	<th>系統1</th>
	<th>RAC1</th>
	<th>成分2</th>
	<th>回数2</th>
	<th>系統2</th>
	<th>RAC2</th>
	<th>対象病害虫等</th>
	<th>対象病害虫数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>なす</td>
	<td>炭酸水素ナトリウム・銅水和剤</td>
	<td>ジーファイン水和剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>-</td>
	<td>散布</td>
	<td>150～500L/10a</td>
	<td>炭酸水素ナトリウム</td>
	<td>-</td>
	<td>炭酸水素塩</td>
	<td>F:NC</td>
	<td>銅</td>
	<td>-</td>
	<td>無機銅</td>
	<td>F:M1</td>
	<td>うどんこ病 1000～2000倍</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1993.12.01</td>
</tr>
<tr class="even">
	<td>殺虫剤</td>
	<td>野菜類(いちご、トマト、ミニトマトを除く)</td>
	<td>還元澱粉糖化物液剤</td>
	<td>エコピタ液剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>-</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>還元澱粉糖化物</td>
	<td>-</td>
	<td>その他</td>
	<td>I:未</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>うどんこ病 100倍, アブラムシ類 100倍, コナジラミ類 100倍, ハダニ類 100倍</td>
	<td>4</td>
	<td>液剤</td>
	<td>殺虫</td>
	<td>1</td>
	<td>2005.12.14</td>
</tr>
<tr class="odd">
	<td>殺虫剤</td>
	<td>なす</td>
	<td>スピノサド水和剤</td>
	<td>スピノエース顆粒水和剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>2回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>スピノサド</td>
	<td>2回以内</td>
	<td>スピノシン</td>
	<td>I:5</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>アザミウマ類 2500～5000倍, オオタバコガ 5000倍</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺虫</td>
	<td>1</td>
	<td>1999.04.19</td>
</tr>
</table>
<table border="1" id="trow">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>使用方法</th>
	<th>散布液量</th>
	<th>有効成分</th>
	<th>使用回数</th>
	<th>系統名</th>
	<th>RACコード</th>
	<th>対象病害虫等</th>
	<th>対象病害虫数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>なす</td>
	<td>炭酸水素ナトリウム・銅水和剤</td>
	<td>ジーファイン水和剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>-</td>
	<td>散布</td>
	<td>150～500L/10a</td>
	<td>炭酸水素ナトリウム<br>銅</td>
	<td>-<br>-</td>
	<td>炭酸水素塩<br>無機銅</td>
	<td>F:NC<br>F:M1</td>
	<td>うどんこ病 1000～2000倍</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1993.12.01</td>
</tr>
<tr class="even">
	<td>殺虫剤</td>
	<td>野菜類(いちご、トマト、ミニトマトを除く)</td>
	<td>還元澱粉糖化物液剤</td>
	<td>エコピタ液剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>-</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>還元澱粉糖化物</td>
	<td>-</td>
	<td>その他</td>
	<td>I:未</td>
	<td>うどんこ病 100倍, アブラムシ類 100倍, コナジラミ類 100倍, ハダニ類 100倍</td>
	<td>4</td>
	<td>液剤</td>
	<td>殺虫</td>
	<td>1</td>
	<td>2005.12.14</td>
</tr>
<tr class="odd">
	<td>殺虫剤</td>
	<td>なす</td>
	<td>スピノサド水和剤</td>
	<td>スピノエース顆粒水和剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>2回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>スピノサド</td>
	<td>2回以内</td>
	<td>スピノシン</td>
	<td>I:5</td>
	<td>アザミウマ類 2500～5000倍, オオタバコガ 5000倍</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺虫</td>
	<td>1</td>
	<td>1999.04.19</td>
</tr>
</table>
<table border="1" id="tclb">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>使用方法</th>
	<th>散布液量</th>
	<th>有効成分</th>
	<th>使用回数</th>
	<th>系統名</th>
	<th>RACコード</th>
	<th>対象病害虫等</th>
	<th>対象病害虫数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>なす</td>
	<td>炭酸水素ナトリウム・銅水和剤</td>
	<td>ジーファイン水和剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>-</td>
	<td>散布</td>
	<td>150～500L/10a</td>
	<td>1 炭酸水素ナトリウム<br>2 銅</td>
	<td>1 -<br>2 -</td>
	<td>1 炭酸水素塩<br>2 無機銅</td>
	<td>1 F:NC<br>2 F:M1</td>
	<td>うどんこ病 1000～2000倍</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1993.12.01</td>
</tr>
<tr class="even">
	<td>殺虫剤</td>
	<td>野菜類(いちご、トマト、ミニトマトを除く)</td>
	<td>還元澱粉糖化物液剤</td>
	<td>エコピタ液剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>-</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>還元澱粉糖化物</td>
	<td>-</td>
	<td>その他</td>
	<td>I:未</td>
	<td>うどんこ病 100倍, アブラムシ類 100倍, コナジラミ類 100倍, ハダニ類 100倍</td>
	<td>4</td>
	<td>液剤</td>
	<td>殺虫</td>
	<td>1</td>
	<td>2005.12.14</td>
</tr>
<tr class="odd">
	<td>殺虫剤</td>
	<td>なす</td>
	<td>スピノサド水和剤</td>
	<td>スピノエース顆粒水和剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>2回以内</td>
	<td>散布</td>
	<td>100～300L/10a</td>
	<td>スピノサド</td>
	<td>2回以内</td>
	<td>スピノシン</td>
	<td>I:5</td>
	<td>アザミウマ類 2500～5000倍, オオタバコガ 5000倍</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺虫</td>
	<td>1</td>
	<td>1999.04.19</td>
</tr>
</table>
<h2>設定項目</h2>
<dl>
<dt>■ 作物名</dt>
<dd>
<p>検索対象とする作物系統を１系統のみ指定できます。<em>[必須]</em></p>
<p>「作物群一括検索」で「する」を選択した場合、作物名に「'きゅうり'」だけを指定しても「きゅうり」以外に上位作物群の「うり類(未成熟),うり科野菜類,うり類,野菜類」のほか、
下位作物群である「きゅうり(施設栽培),きゅうり(露地栽培(移植栽培)),きゅうり(露地栽培(直播栽培))」も含めて検索します。
作物名に「'きゅうり(施設栽培)'」を指定した場合は、上位作物群の「きゅうり,うり類(未成熟),うり科野菜類,うり類,野菜類」(ただし「野菜類(露地栽培)」は除く)を検索します。</p>
<p>登録農薬が多い作物で大作物群などの上位作物群まで含めて検索したくない場合は、「作物群一括検索」で「しない」を選択し、
「'きゅうり(施設野菜),きゅうり'」あるいは「'きゅうり,うり類(未成熟),うり科野菜類,うり類'」などのように遡る作物群を限定します。
作物群一括検索「しない」でも、「'きゅうり'」を指定した場合、下位作物群である「きゅうり(施設栽培),きゅうり(露地栽培(移植栽培)),きゅうり(露地栽培(直播栽培))」も含めて検索します。</p>
</dd>
<dt>□ 用途</dt>
<dd>
<p>検索対象とする用途を指定します。無指定の場合は、全ての用途を検索します。</p>
<p>複数指定可能ですが、殺虫剤一覧を作成する場合は「殺虫剤」または「殺虫剤, 殺虫殺菌剤」、殺菌剤一覧を作成する場合は「殺菌剤」または「殺菌剤, 殺虫殺菌剤」を選択すると良いでしょう。</p>
</dd>
<dt>□ その他</dt>
<dd>
<p>上記以外の項目を検索条件にしたい場合、条件式を直接記述します。使用時期・使用方法などを限定したい場合や、特定の通称のみを表示したい場合などに使用します。</p>
<p>収穫期に使用可能な散布剤だけを検索したい場合は、「収穫期散布剤.arg」を読み込んでください。</p>
</dd>
</dl>
<h2>設定例</h2>
<div>
<p><span class="button">設定読込</span>ボタンをクリックして、下記ファイルを選択してください。</p>
<pre>
施設きゅうり有機JAS使用可能殺菌剤.arg
露地なす有機JAS使用可能農薬.arg
</pre>
</div>
<h2>定義</h2>
<dl>
<dt>テンプレート定義</dt>
<dd><xmp id="sql">
#template {
--/d
drop table if exists tTpl;
create temp table tTpl as
select distinct
  bango,yoto,sakumotsu,shurui,tsusho,dokusei,jiki,kaisu,hoho,ekiryo,byochu,mokuteki,baisu,
  seibun1,seibun2,seibun3,seibun4,seibun5,
  kaisu1,kaisu2,kaisu3,kaisu4,kaisu5,
  keito1,keito2,keito3,keito4,keito5,
  null as rac1, null as rac2, null as rac3, null as rac4, null as rac5,
  kongo,zaikei,koka,
  zenkoku as ryutsu,
  zenkoku,torokubi
from m_tekiyo left join m_kihon using(bango) left join seizai using(bango) left join idshurui using(bango) left join ryutsu using(idshurui)
where
  (
    shurui in (select item from spec.ojas where cat = 'jas' and class = 'shurui')
    or concat('',seibun1,seibun2,seibun3,seibun4,seibun5) in (select item from spec.ojas where cat = 'jas' and class = 'seibun')
    or concat('',keito1,keito2,keito3,keito4,keito5) in (select item from spec.ojas where cat = 'jas' and class = 'keito')
    --or shurui in (select item from spec.ojas where cat = 'tokusai' and class = 'shurui')
  ) and 
  --ryakusho <> 'ホクサン株式会社' and
  --ryakusho <> '琉球産経株式会社' and
  --yoto in (<yoto>) and
  --<sonota> and
  sakumotsu in (select sakumotsu from m_sakumotsu left join sakuhojo using(idsaku) where 
    '、'||concat('、', sakumotsu, shozoku)||'、' regexp <~sakumotsu~> and nozoku not regexp <~sakumotsu~> or fukumu regexp <~sakumotsu~>
  );
update tTpl set kaisu1 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun1), kaisu1) where kaisu1 is not null;
update tTpl set kaisu2 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun2), kaisu2) where kaisu2 is not null;
update tTpl set kaisu3 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun3), kaisu3) where kaisu3 is not null;
update tTpl set kaisu4 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun4), kaisu4) where kaisu4 is not null;
update tTpl set kaisu5 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun5), kaisu5) where kaisu5 is not null;
update tTpl set rac1 = (select mid from rac where ippanmei = seibun1) where seibun1 is not null;
update tTpl set rac2 = (select mid from rac where ippanmei = seibun2) where seibun2 is not null;
update tTpl set rac3 = (select mid from rac where ippanmei = seibun3) where seibun3 is not null;
update tTpl set rac4 = (select mid from rac where ippanmei = seibun4) where seibun4 is not null;
update tTpl set rac5 = (select mid from rac where ippanmei = seibun5) where seibun5 is not null;
select
  yoto,sakumotsu,shurui,tsusho,dokusei,jiki,kaisu,hoho,
  max(ekiryo) as ekiryo,
  seibun1,kaisu1,keito1,rac1,
  seibun2,kaisu2,keito2,rac2,
  seibun3,kaisu3,keito3,rac3,
  seibun4,kaisu4,keito4,rac4,
  seibun5,kaisu5,keito5,rac5,
  --concat2(x'1d0d', seibun1, seibun2, seibun3, seibun4, seibun5) as ippanmei,
  --concat2(x'1d0d', kaisu1, kaisu2, kaisu3, kaisu4, kaisu5) as 使用回数,
  --concat2(x'1d0d', keito1, keito2, keito3, keito4, keito5) as keito,
  --concat2(x'1d0d', rac1, rac2, rac3, rac4, rac5) as mid,
  --concat2(x'1f0d', if(seibun2 is null, '', '1 ')||seibun1, '2 '||seibun2, '3 '||seibun3, '4 '||seibun4, '5 '||seibun5) as ippanmei,
  --concat2(x'1f0d', if(kaisu2 is null, '', '1 ')||kaisu1, '2 '||kaisu2, '3 '||kaisu3, '4 '||kaisu4, '5 '||kaisu5) as 使用回数,
  --concat2(x'1f0d', if(keito2 is null, '', '1 ')||keito1, '2 '||keito2, '3 '||keito3, '4 '||keito4, '5 '||keito5) as keito,
  --concat2(x'1f0d', if(rac2 is null, '', '1 ')||rac1, '2 '||rac2, '3 '||rac3, '4 '||rac4, '5 '||rac5) as mid,
  concat(', ', concat('', byochu, mokuteki, ' ', baisu)) as 対象病害虫等,
  count(distinct concat('', byochu, mokuteki)) as 対象病害虫数,
  kongo,zaikei,koka,
  if(zenkoku, ryutsu, ifnull(zenkoku, -1) - 1) as 流通,
  min(torokubi) as torokubi
from tTpl
group by sakumotsu, tsusho, dokusei, kaisu, jiki, hoho
order by yoto, tsusho;
}
</xmp></dd>
<dt>デフォルト定義</dt>
<dd><pre>
#default {
}
</pre></dd>
</dl>
</body>
</html>
