<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<meta name="Author" content="OhYeah!">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="IE=Edge">
<link rel="stylesheet" href="template.css" type="text/css">
<title>ACFinder Template</title>
<script type="text/javascript" src="template.js"></script>
</head>
<body onload="init('',autodep());">
<h1>特定作物噴霧剤薬液成分濃度 (2024.7.16版)</h1>
<p>特定の作物系統(と病害虫)を指定すると、その作物系統(と病害虫)に登録のある噴霧剤を検索して、下記のような一覧表を作成します。
希釈薬液の成分濃度(使用可能な最高濃度)を計算することで、万一ドリフトした場合になるべく影響が少ない農薬を調べることができます。
有効成分の残効期間や隣接作物の可食部位・残留基準値も考慮する必要がありますが、薬液濃度がなるべく低い農薬がドリフトに対してより安全といえます。</p>
<p>今のところ、製剤の有効成分濃度の単位が「％」以外の農薬(ＢＴ剤等)、希釈倍数使用量が「○○倍」「原液」以外の農薬(除草剤、植物成長調整剤、粒剤、粉剤等)には対応していません。</p>
<form name="F1" action="#" id="cbox"></form>
<table border="1" id="tcol">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>使用方法</th>
	<th>対象病害虫</th>
	<th>希釈倍数</th>
	<th>散布液量</th>
	<th>成分1</th>
	<th>回数1</th>
	<th>含有率1</th>
	<th>薬液濃度1</th>
	<th>系統1</th>
	<th>RAC1</th>
	<th>成分2</th>
	<th>回数2</th>
	<th>含有率2</th>
	<th>薬液濃度2</th>
	<th>系統2</th>
	<th>RAC2</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>なす</td>
	<td>ジエトフェンカルブ・チオファネートメチル水和剤</td>
	<td>ゲッター水和剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>5回以内</td>
	<td>散布</td>
	<td>灰色かび病</td>
	<td>1000.0倍</td>
	<td>100～300L/10a</td>
	<td>ジエトフェンカルブ</td>
	<td>5回以内</td>
	<td>12.5%</td>
	<td>125.0ppm</td>
	<td>N-フェニルカーバメート</td>
	<td>F:10</td>
	<td>チオファネートメチル</td>
	<td>6回以内(種子への処理は1回以内、は種後は5回以内)</td>
	<td>52.5%</td>
	<td>525.0ppm</td>
	<td>ベンズイミダゾール</td>
	<td>F:1</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1990.11.07</td>
</tr>
<tr class="even">
	<td>殺菌剤</td>
	<td>野菜類</td>
	<td>炭酸水素ナトリウム水溶剤</td>
	<td>ハーモメイト水溶剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>-</td>
	<td>散布</td>
	<td>灰色かび病</td>
	<td>800.0倍</td>
	<td>150～300L/10a</td>
	<td>炭酸水素ナトリウム</td>
	<td>-</td>
	<td>80.0%</td>
	<td>1000.0ppm</td>
	<td>炭酸水素塩</td>
	<td>F:NC</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>1</td>
	<td>水溶剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1994.09.20</td>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>なす</td>
	<td>フェンピラザミン水和剤</td>
	<td>ピクシオDF</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>4回以内</td>
	<td>散布</td>
	<td>灰色かび病</td>
	<td>2000.0倍</td>
	<td>100～300L/10a</td>
	<td>フェンピラザミン</td>
	<td>4回以内</td>
	<td>50.0%</td>
	<td>250.0ppm</td>
	<td>アミドピラゾリノン</td>
	<td>F:17</td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td></td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>-2</td>
	<td>2013.07.02</td>
</tr>
</table>
<table border="1" id="trow">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>使用方法</th>
	<th>対象病害虫</th>
	<th>希釈倍数</th>
	<th>散布液量</th>
	<th>有効成分</th>
	<th>使用回数</th>
	<th>含有率</th>
	<th>薬液濃度</th>
	<th>系統名</th>
	<th>RACコード</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>なす</td>
	<td>ジエトフェンカルブ・チオファネートメチル水和剤</td>
	<td>ゲッター水和剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>5回以内</td>
	<td>散布</td>
	<td>灰色かび病</td>
	<td>1000.0倍</td>
	<td>100～300L/10a</td>
	<td>ジエトフェンカルブ<br>チオファネートメチル</td>
	<td>5回以内<br>6回以内(種子への処理は1回以内、は種後は5回以内)</td>
	<td>12.5%<br>52.5%</td>
	<td>125.0ppm<br>  525.0ppm</td>
	<td>N-フェニルカーバメート<br>ベンズイミダゾール</td>
	<td>F:10<br>F:1</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1990.11.07</td>
</tr>
<tr class="even">
	<td>殺菌剤</td>
	<td>野菜類</td>
	<td>炭酸水素ナトリウム水溶剤</td>
	<td>ハーモメイト水溶剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>-</td>
	<td>散布</td>
	<td>灰色かび病</td>
	<td>800.0倍</td>
	<td>150～300L/10a</td>
	<td>炭酸水素ナトリウム</td>
	<td>-</td>
	<td>80.0%</td>
	<td>1000.0ppm</td>
	<td>炭酸水素塩</td>
	<td>F:NC</td>
	<td>1</td>
	<td>水溶剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1994.09.20</td>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>なす</td>
	<td>フェンピラザミン水和剤</td>
	<td>ピクシオDF</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>4回以内</td>
	<td>散布</td>
	<td>灰色かび病</td>
	<td>2000.0倍</td>
	<td>100～300L/10a</td>
	<td>フェンピラザミン</td>
	<td>4回以内</td>
	<td>50.0%</td>
	<td>250.0ppm</td>
	<td>アミドピラゾリノン</td>
	<td>F:17</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>-2</td>
	<td>2013.07.02</td>
</tr>
</table>
<table border="1" id="tclb">
<tr class="header">
	<th>用途</th>
	<th>作物名</th>
	<th>農薬の種類</th>
	<th>農薬通称</th>
	<th>毒性</th>
	<th>使用時期</th>
	<th>本剤の使用回数</th>
	<th>使用方法</th>
	<th>対象病害虫</th>
	<th>希釈倍数</th>
	<th>散布液量</th>
	<th>有効成分</th>
	<th>使用回数</th>
	<th>含有率</th>
	<th>薬液濃度</th>
	<th>系統名</th>
	<th>RACコード</th>
	<th>混合数</th>
	<th>剤型</th>
	<th>効果</th>
	<th>流通</th>
	<th>登録年月日</th>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>なす</td>
	<td>ジエトフェンカルブ・チオファネートメチル水和剤</td>
	<td>ゲッター水和剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>5回以内</td>
	<td>散布</td>
	<td>灰色かび病</td>
	<td>1000.0倍</td>
	<td>100～300L/10a</td>
	<td>1 ジエトフェンカルブ<br>2 チオファネートメチル</td>
	<td>1 5回以内<br>2 6回以内(種子への処理は1回以内、は種後は5回以内)</td>
	<td>1 12.5%<br>2 52.5%</td>
	<td>1 125.0ppm<br>2 525.0ppm</td>
	<td>1 N-フェニルカーバメート<br>2 ベンズイミダゾール</td>
	<td>1 F:10<br>2 F:1</td>
	<td>2</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1990.11.07</td>
</tr>
<tr class="even">
	<td>殺菌剤</td>
	<td>野菜類</td>
	<td>炭酸水素ナトリウム水溶剤</td>
	<td>ハーモメイト水溶剤</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>-</td>
	<td>散布</td>
	<td>灰色かび病</td>
	<td>800.0倍</td>
	<td>150～300L/10a</td>
	<td>炭酸水素ナトリウム</td>
	<td>-</td>
	<td>80.0%</td>
	<td>1000.0ppm</td>
	<td>炭酸水素塩</td>
	<td>F:NC</td>
	<td>1</td>
	<td>水溶剤</td>
	<td>殺菌(治療)</td>
	<td>1</td>
	<td>1994.09.20</td>
</tr>
<tr class="odd">
	<td>殺菌剤</td>
	<td>なす</td>
	<td>フェンピラザミン水和剤</td>
	<td>ピクシオDF</td>
	<td>普</td>
	<td>収穫前日まで</td>
	<td>4回以内</td>
	<td>散布</td>
	<td>灰色かび病</td>
	<td>2000.0倍</td>
	<td>100～300L/10a</td>
	<td>フェンピラザミン</td>
	<td>4回以内</td>
	<td>50.0%</td>
	<td>250.0ppm</td>
	<td>アミドピラゾリノン</td>
	<td>F:17</td>
	<td>1</td>
	<td>水和剤</td>
	<td>殺菌(治療)</td>
	<td>-2</td>
	<td>2013.07.02</td>
</tr>
</table>
<h2>設定項目</h2>
<dl>
<dt>■ 作物名</dt>
<dd>
<p>検索対象とする作物系統を１系統のみ指定できます。<em>[必須]</em></p>
<p>作物系統とは、目的とする作物名(栽培条件等を限定する場合は詳細作物名)やその上位作物群名を列挙したものを指します。</p>
<p>「作物群一括検索」で「する」を選択した場合、作物名に「きゅうり」だけを指定しても「きゅうり」以外に上位作物群の「うり類(未成熟),うり科野菜類,うり類,野菜類」のほか、
下位作物群である「きゅうり(施設栽培),きゅうり(露地栽培(移植栽培)),きゅうり(露地栽培(直播栽培))」も含めて検索します。
作物名に「きゅうり(施設栽培)」を指定した場合は、上位作物群の「きゅうり,うり類(未成熟),うり科野菜類,うり類,野菜類」(ただし「野菜類(露地栽培)」は除く)を検索します。</p>
</dd>
<dt>□ 病害虫</dt>
<dd>
<p>検索対象とする病害虫を複数指定できます。</p>
<dt>□ 用途</dt>
<dd>
<p>検索対象とする用途を指定します。無指定の場合は、全ての用途を検索します。</p>
<p>複数指定可能ですが、殺虫剤一覧を作成する場合は「殺虫剤」または「殺虫剤, 殺虫殺菌剤」、殺菌剤一覧を作成する場合は「殺菌剤」または「殺菌剤, 殺虫殺菌剤」を選択すると良いでしょう。</p>
</dd>
<dt>□ その他</dt>
<dd>
<p>上記以外の項目を検索条件にしたい場合、条件式を直接記述します。使用時期・使用方法などを限定したい場合や、特定の通称のみを表示したい場合などに使用します。</p>
<p>収穫期に使用可能な散布剤だけを検索したい場合は、「収穫期散布剤.arg」を読み込んでください。</p>
</dd>
</dl>
<h2>設定例</h2>
<div>
<p><span class="button">設定読込</span>ボタンをクリックして、下記ファイルを選択してください。</p>
<pre>
露地なす殺虫剤.arg
露地なす灰色かび病.arg
</pre>
</div>
<h2>定義</h2>
<dl>
<dt>テンプレート定義</dt>
<dd><xmp id="sql">
#template {
--/d
drop table if exists tTpl;
create temp table tTpl as
select
  bango,yoto,sakumotsu,shurui,tsusho,dokusei,jiki,kaisu,hoho,
  max(ekiryo) as ekiryo,
  concat(', ', byochu) as 対象病害虫,
  min(extnum('(～[0-9]+)?倍', baisu, 1)) as bai,
  seibun1,seibun2,seibun3,seibun4,seibun5,
  kaisu1,kaisu2,kaisu3,kaisu4,kaisu5,
  keito1,keito2,keito3,keito4,keito5,
  null as rac1, null as rac2, null as rac3, null as rac4, null as rac5,
  null as nodo1,null as nodo2,null as nodo3,null as nodo4,null as nodo5,
  null as ynodo1,null as ynodo2,null as ynodo3,null as ynodo4,null as ynodo5,
  kongo,zaikei,koka,
  zenkoku as ryutsu,
  zenkoku,torokubi
from m_tekiyo left join m_kihon using(bango) left join seizai using(bango) left join idshurui using(bango) left join ryutsu using(idshurui)
where
  --ryakusho <> 'ホクサン株式会社' and
  --ryakusho <> '琉球産経株式会社' and
  --byochu in (<byochu>) and
  --yoto in (<yoto>) and
  --zaikei in (<zaikei>) and
  --<sonota> and
  hoho like '%散布%' and
  zaikei in ('乳剤', '水和剤', '水溶剤', '液剤', 'マイクロカプセル剤') and
  baisu not regexp 'l|g|㎏|ppm' and
/*nodeploy
  sakumotsu in (
    select sakumotsu from m_sakumotsu where toroku = 1 and sakumotsu regexp '(^|、|\()('||</sakumotsu/>||')(\(.*?(栽培|除く)|\)|、|等|$)' and
           sakumotsu not regexp replace(replace(<!sakumotsu!>,'\(?','(\('),'\)?','\))?')||if(</sakumotsu/> like '%うり類%' and </sakumotsu/> not like '%漬物用%','|\(漬物用','')
  )
nodeploy*/
--/*autodeploy
  sakumotsu in (select sakumotsu from m_sakumotsu where idsaku regexp (
    select '^('||concat('|',if(class=5,idsaku),if(class>3,substr(idsaku,1,12)||if(class=4,'','0000')),if(class<4,substr(idsaku,1,8)||if(class=3,'','0000')),
      substr(idsaku,1,6)||'000000',substr(idsaku,1,4)||'00000000',substr(idsaku,1,2)||'0000000000',
      if(gunmei is not null,(select substr(idsaku,1,12) from m_sakumotsu where sakumotsu = a.gunmei)),
      (select concat('|',idsaku) from m_sakumotsu where sakumotsu not like '%除く%' and sakumotsu regexp '(^|\(|、)('||</sakumotsu/>||')(\(.*?(栽培|除く)|\)|、|等|$)'))||')'
    from m_sakumotsu as a where toroku = 1 and sakumotsu match '[#sakumotsu#]')
    and sakumotsu not regexp replace(replace(<!sakumotsu!>,'\(?','(\('),'\)?','\))?')||if(</sakumotsu/> like '%うり類%' and </sakumotsu/> not like '%漬物用%','|\(漬物用','')
  )
--autodeploy*/
group by bango, dokusei, sakumotsu, jiki, kaisu, hoho;
update tTpl set kaisu1 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun1), kaisu1) where kaisu1 is not null;
update tTpl set kaisu2 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun2), kaisu2) where kaisu2 is not null;
update tTpl set kaisu3 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun3), kaisu3) where kaisu3 is not null;
update tTpl set kaisu4 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun4), kaisu4) where kaisu4 is not null;
update tTpl set kaisu5 = concat(': ', (select shoryaku from tseibun where ippanmei = seibun5), kaisu5) where kaisu5 is not null;
update tTpl set rac1 = (select mid from rac where ippanmei = seibun1) where seibun1 is not null;
update tTpl set rac2 = (select mid from rac where ippanmei = seibun2) where seibun2 is not null;
update tTpl set rac3 = (select mid from rac where ippanmei = seibun3) where seibun3 is not null;
update tTpl set rac4 = (select mid from rac where ippanmei = seibun4) where seibun4 is not null;
update tTpl set rac5 = (select mid from rac where ippanmei = seibun5) where seibun5 is not null;
update tTpl set nodo1 = (select nodo from seibun where bango = tTpl.bango and seibun1 in (ippanmei,seibun)) where seibun1 is not null;
update tTpl set nodo2 = (select nodo from seibun where bango = tTpl.bango and seibun2 in (ippanmei,seibun)) where seibun2 is not null;
update tTpl set nodo3 = (select nodo from seibun where bango = tTpl.bango and seibun3 in (ippanmei,seibun)) where seibun3 is not null;
update tTpl set nodo4 = (select nodo from seibun where bango = tTpl.bango and seibun4 in (ippanmei,seibun)) where seibun4 is not null;
update tTpl set nodo5 = (select nodo from seibun where bango = tTpl.bango and seibun5 in (ippanmei,seibun)) where seibun5 is not null;
update tTpl set ynodo1 = substr('    '||round(extnum('%', nodo1) * 10000 / bai), -7)||'ppm' where nodo1 like '%$%' escape '$';
update tTpl set ynodo2 = substr('    '||round(extnum('%', nodo2) * 10000 / bai), -7)||'ppm' where nodo2 like '%$%' escape '$';
update tTpl set ynodo3 = substr('    '||round(extnum('%', nodo3) * 10000 / bai), -7)||'ppm' where nodo3 like '%$%' escape '$';
update tTpl set ynodo4 = substr('    '||round(extnum('%', nodo4) * 10000 / bai), -7)||'ppm' where nodo4 like '%$%' escape '$';
update tTpl set ynodo5 = substr('    '||round(extnum('%', nodo5) * 10000 / bai), -7)||'ppm' where nodo5 like '%$%' escape '$';
select
  yoto,sakumotsu,shurui,tsusho,dokusei,jiki,kaisu,hoho,
  対象病害虫,
  substr('    '||bai, -7)||'倍' as 希釈倍数,
  ekiryo,
  seibun1,kaisu1,nodo1 as 含有率1,ynodo1 as 薬液濃度1,keito1,rac1,
  seibun2,kaisu2,nodo2 as 含有率2,ynodo2 as 薬液濃度2,keito2,rac2,
  seibun3,kaisu3,nodo3 as 含有率3,ynodo3 as 薬液濃度3,keito3,rac3,
  seibun4,kaisu4,nodo4 as 含有率4,ynodo4 as 薬液濃度4,keito4,rac4,
  seibun5,kaisu5,nodo5 as 含有率5,ynodo5 as 薬液濃度5,keito5,rac5,
  --concat2(x'1d0d', seibun1, seibun2, seibun3, seibun4, seibun5) as ippanmei,
  --concat2(x'1d0d', kaisu1, kaisu2, kaisu3, kaisu4, kaisu5) as 使用回数,
  --concat2(x'1d0d', nodo1, nodo2, nodo3, nodo4, nodo5) as 含有率,
  --concat2(x'1d0d', ynodo1, ynodo2, ynodo3, ynodo4, ynodo5) as 薬液濃度,
  --concat2(x'1d0d', keito1, keito2, keito3, keito4, keito5) as keito,
  --concat2(x'1d0d', rac1, rac2, rac3, rac4, rac5) as mid,
  --concat2(x'1f0d', if(seibun2 is null, '', '1 ')||seibun1, '2 '||seibun2, '3 '||seibun3, '4 '||seibun4, '5 '||seibun5) as ippanmei,
  --concat2(x'1f0d', if(kaisu2 is null, '', '1 ')||kaisu1, '2 '||kaisu2, '3 '||kaisu3, '4 '||kaisu4, '5 '||kaisu5) as 使用回数,
  --concat2(x'1f0d', if(nodo2 is null, '', '1 ')||nodo1, '2 '||nodo2, '3 '||nodo3, '4 '||nodo4, '5 '||nodo5) as 含有率,
  --concat2(x'1f0d', if(ynodo2 is null, '', '1 ')||ynodo1, '2 '||ynodo2, '3 '||ynodo3, '4 '||ynodo4, '5 '||ynodo5) as 薬液濃度,
  --concat2(x'1f0d', if(keito2 is null, '', '1 ')||keito1, '2 '||keito2, '3 '||keito3, '4 '||keito4, '5 '||keito5) as keito,
  --concat2(x'1f0d', if(rac2 is null, '', '1 ')||rac1, '2 '||rac2, '3 '||rac3, '4 '||rac4, '5 '||rac5) as mid,
  kongo,zaikei,koka,
  if(zenkoku, ryutsu, ifnull(zenkoku, -1) - 1) as 流通,
  min(torokubi) as torokubi
from tTpl
group by sakumotsu, tsusho, dokusei, kaisu, jiki, hoho, 対象病害虫, bai
order by yoto, tsusho;
}
</xmp></dd>
<dt>デフォルト定義</dt>
<dd><pre>
#default {
}
</pre></dd>
</dl>
</body>
</html>
