<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<meta name="Author" content="OhYeah!">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="IE=Edge">
<link rel="stylesheet" href="template.css" type="text/css">
<title>ACFinder Template</title>
<script type="text/javascript">
function opt1() {
  var cbox =
  '<li>RAC区分<select name="O1" onChange="SelCat()">'+
  '<option value="frac">FRAC'+
  '<option value="irac">IRAC'+
  '<option value="hrac">HRAC'+
  '</select><div class="balloon">'+
  '<p>殺菌剤の RAC 作用機構分類一覧を作成したい場合は「FRAC」、殺虫剤は「IRAC」、除草剤は「HRAC」を選択してください。</p>'+
  '<span class="arrow"><span class="inarrow"></span></span>'+
  "</div></li>\r\n";
  return cbox;
}
function opt2() {
  var cbox =
  '<li>剤型表示<select name="O2" onChange="SelForm()">'+
  '<option value="yes">あり'+
  '<option value="no">なし'+
  '</select><div class="balloon">'+
  '<p>該当農薬通称に剤型を含めて表示したい場合は「あり」、剤型を表示しない場合は「なし」を選択してください。</p>'+
  '<span class="arrow"><span class="inarrow"></span></span>'+
  "</div></li>\r\n";
  return cbox;
}
function disptbl(tbl){
  document.getElementById('frac').style.display = 'none';
  document.getElementById('irac').style.display = 'none';
  document.getElementById('hrac').style.display = 'none';
  document.getElementById(tbl).style.display = 'block';
}
function init() {
  disptbl('frac');
  document.getElementById('cbox').innerHTML = opt1() + opt2();
}
function SelCat() {
  var n = document.F1.O1.selectedIndex;
  var ctyp = document.F1.O1.options[n].value;
  var node = document.getElementById('sql');
  disptbl(ctyp);
  node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/[FHI]RAC(?=コード,)/, ctyp.toUpperCase());
  if (ctyp == 'hrac') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/  (?=sayokiko)/g, "--");
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/--(?=lhrac)/, "  ");
  } else if (ctyp == 'irac') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/  (?=sayokiko, sayoten, fgroup)/, "--");
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/--(?=sayokiko, sayoten, keito)/, "  ");
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/  (?=lhrac)/, "--");
  } else {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/--(?=sayokiko, sayoten, fgroup)/, "  ");
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/  (?=sayokiko, sayoten, keito)/, "--");
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/  (?=lhrac)/, "--");
  }
}
function SelForm() {
  var n = document.F1.O2.selectedIndex;
  var ctyp = document.F1.O2.options[n].value;
  var node = document.getElementById('sql');
  if (ctyp == 'yes') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/  (?=update tTpl[12] set tsusho)/, "--");
  } else {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/--(?=update tTpl[12] set tsusho)/, "  ");
  }
}
</script>
</head>
<body onload="init()">
<h1>特定作物RAC作用機構分類一覧 (2024.7.16版)</h1>
<p>作物名を単独で指定しても、上位作物群を含む作物系統に全てに登録のある農薬を検索して、下記のようなRACコード分類一覧表を作成します。</p>
<p>各RAC作用機構分類のバージョンは、SQLタブで「RACバージョン.qry」を読み込んで実行すると確認できます。</p>
<form name="F1" action="#" id="cbox"></form>
<table border="1" id="frac">
<tr class="header">
	<th>FRACコード</th>
	<th>作用機構</th>
	<th>作用点</th>
	<th>FRAC系統</th>
	<th>系統</th>
	<th>FRAC耐性リスク</th>
	<th>有効成分</th>
	<th>農薬通称</th>
</tr>
<tr class="odd">
	<td>7</td>
	<td>C呼吸</td>
	<td>C2:複合体Ⅱ:コハク酸脱水素酵素</td>
	<td>SDHI(コハク酸脱水素酵素阻害剤)</td>
	<td>ピラゾール-4-カルボキサミド</td>
	<td>中～高(耐性管理ガイドライン有り)、複数の耐性菌</td>
	<td>ペンチオピラド</td>
	<td>アフェット,スターガードプラス[I:4A],ピカット[9],ベジセイバー[M05]</td>
</tr>
<tr class="even">
	<td>3</td>
	<td>G細胞膜のステロール生合成</td>
	<td>G1:ステロール生合成におけるC14位の脱メチル化(erg11/cyp51)</td>
	<td>DMI殺菌剤(脱メチル化阻害剤)(SBI:クラスI)</td>
	<td>トリアゾール</td>
	<td>中(耐性管理ガイドライン有り)(他のSBIクラスと交差しない)、各種の菌で耐性</td>
	<td>トリフルミゾール</td>
	<td>トリフミン,パンチョTF[U06]</td>
</tr>
<tr class="odd">
	<td>M04</td>
	<td>M多作用点接触活性</td>
	<td>多作用点接触活性</td>
	<td>フタルイミド(求電子剤)</td>
	<td>フタルイミド</td>
	<td>低</td>
	<td>キャプタン</td>
	<td>アリエッティC[P07],オキシラン[M01],オーソサイド,キャプレート[1],ダイパワー[M07],ポリキャプタン[19]</td>
</tr>
</table>
<table border="1" id="irac">
<tr class="header">
	<th>IRACコード</th>
	<th>作用機構</th>
	<th>作用点</th>
	<th>系統</th>
	<th>有効成分</th>
	<th>農薬通称</th>
</tr>
<tr class="odd">
	<td>4A</td>
	<td>神経作用</td>
	<td>ニコチン性アセチルコリン受容体(nAChR)競合的調節</td>
	<td>ネオニコチノイド</td>
	<td>クロチアニジン</td>
	<td>ダントツ, ベニカ, ベニカベジフルV, ベニカVフレッシュ</td>
</tr>
<tr class="even">
	<td>5</td>
	<td>神経作用</td>
	<td>ニコチン性アセチルコリン受容体(nAChR)アロステリック調節-部位I</td>
	<td>スピノシン</td>
	<td>スピネトラム</td>
	<td>ディアナ, デリゲート</td>
</tr>
<tr class="odd">
	<td>20(D)</td>
	<td>エネルギー代謝</td>
	<td>ミトコンドリア電子伝達系複合体III阻害</td>
	<td>ヒドラジン系</td>
	<td>ビフェナゼート</td>
	<td>マイトコーネ, ダニ太郎</td>
</tr>
</table>
<table border="1" id="hrac">
<tr class="header">
	<th>HRACコード</th>
	<th>旧分類</th>
	<th>作用機構</th>
	<th>作用点</th>
	<th>系統</th>
	<th>有効成分</th>
	<th>農薬通称</th>
</tr>
<tr class="odd">
	<td>3</td>
	<td>K1</td>
	<td>細胞分裂・成長</td>
	<td>微小管重合阻害</td>
	<td>ジニトロアニリン</td>
	<td>ペンディメタリン</td>
	<td>ゴーゴーサン</td>
</tr>
<tr class="even">
	<td>9</td>
	<td>G</td>
	<td>細胞代謝</td>
	<td>5-エノールピルビルシキミ酸-3-リン酸(EPSP)合成酵素阻害</td>
	<td>グリシン</td>
	<td>グリホサートカリウム塩</td>
	<td>ラウンドアップKロード, ラウンドアップマックスロード, タッチダウン</td>
</tr>
<tr class="odd">
	<td>14</td>
	<td>E</td>
	<td>ROS光活性化</td>
	<td>プロトポルフィリノーゲン酸化酵素(PPO)阻害</td>
	<td>フェニルピラゾール</td>
	<td>ピラフルフェンエチル</td>
	<td>サンダーボルト, クサキングエース, ネコソギクイックプロF</td>
</tr>
</table>
<h2>設定項目</h2>
<dl>
<dt>■ 作物名</dt>
<dd>
<p>検索対象とする作物名を１作物のみ指定できます。<em>[必須]</em></p>
<p>作物名(栽培条件等を限定する場合は詳細作物名)やその上位作物群名を列挙した作物系統でも指定できますが、先頭の作物名のみ使用して独自の作物系統を作成するため、２番目以降の作物群名は無視します。</p>
<p>「作物群一括検索」で「する」を選択した場合、作物名に「きゅうり」だけを指定しても「きゅうり」以外に上位作物群の「うり類(未成熟),うり科野菜類,うり類,野菜類」のほか、
下位作物群である「きゅうり(施設栽培),きゅうり(露地栽培(移植栽培)),きゅうり(露地栽培(直播栽培))」も含めて検索します。
作物名に「きゅうり(施設栽培)」を指定した場合は、上位作物群の「きゅうり,うり類(未成熟),うり科野菜類,うり類,野菜類」(ただし「野菜類(露地栽培)」は除く)を検索します。</p>
</dd>
</dl>
<h2>設定例</h2>
<div>
<p><span class="button">設定読込</span>ボタンをクリックして、下記ファイルを選択してください。</p>
<pre>
なし使用可能農薬RAC作用機構分類.arg
</pre>
</div>
<h2>定義</h2>
<dl>
<dt>テンプレート定義</dt>
<dd><xmp id="sql">
#template {
--/d
drop table if exists tTpl1;
create temp table tTpl1 as select bango, ippanmei, seibun,
if(concat('、',sakumotsu) regexp [%sakumotsu%], 1, 0) as [#sakumotsu#],
re_replace('^(くり|不可欠用途|検疫|.*農地)専用|^(くん蒸|微量注入|粉衣|塗布|緑化|側条|きのこ|わさび|芝|大豆|(家庭)?園芸|(野菜類)?種子消毒)(用)?|^(ヤシマ|NT|エキカ)|粒状(水中)?|固形|強力|防散|撒粉|なげこみ|\(粉状\)', re_replace('((ZY)?-?[0-9]\.?[0-9]*(?![,\-]|号))(グラム|キロ|[GQNSW%]|D(?![FL]))?', tsusho, ''), '') as tsusho,
if(kongo=1,'',(select concat('/', mid) from kihon where bango = a.bango and ippanmei <> a.ippanmei and mid not like '%未' group by bango)) as rac
from kihon as a left join m_tekiyo using(bango) where
  sakumotsu in (select sakumotsu from m_sakumotsu where idsaku regexp (
    select '^('||concat('|',if(class=5,idsaku),if(class>3,substr(idsaku,1,12)||if(class=4,'','0000')),if(class<4,substr(idsaku,1,8)||if(class=3,'','0000')),
      substr(idsaku,1,6)||'000000',substr(idsaku,1,4)||'00000000',substr(idsaku,1,2)||'0000000000',
      if(gunmei is not null,(select substr(idsaku,1,12) from m_sakumotsu where sakumotsu = a.gunmei)),
      (select concat('|',idsaku) from m_sakumotsu where sakumotsu not like '%除く%' and sakumotsu regexp '(^|\(|、)('||</sakumotsu/>||')(\(.*?(栽培|除く)|\)|、|等|$)'))||')'
    from m_sakumotsu as a where toroku = 1 and sakumotsu match '[#sakumotsu#]')
    and sakumotsu not regexp replace(replace(<!sakumotsu!>,'\(?','(\('),'\)?','\))?')||if(</sakumotsu/> like '%うり類%' and </sakumotsu/> not like '%漬物用%','|\(漬物用','')
  )
group by bango, ippanmei order by tsusho;
update tTpl1 set rac = '['||replace(rac, 'F:', '')||']' where rac <> '';
--update tTpl1 set tsusho = re_replace('( |・)?(-?AL|DF|DG|EC|ES|EW|FG|FS|GT|iQ|ME|MK|SC|SE|SG|SL|OD|OS|WD?G|WP|エアー|エアゾール|ゾル|シャワー|(?<!ナイ)スプレー|(マイクロ)?カプセル|顆粒|粉末|小球|原液|塗布剤|粉衣剤|注入剤|アクア(キャップ)?|オイル|ペースト|くん(煙|蒸)(剤)?|(小型)?錠(剤)?|[AGSX]?乳剤|液(剤)?(S|AL)?|水(和|溶)剤|[HLRZ]?(ドライ)?フロアブル[HL]?|((?<!D)[HLRSZ] ?)?ジャンボ[HLP]?|((?<!ル)S|(?<!WR)|[HLUZ]|CR|MC)?(箱|微|粉|細)?粒剤[FHL]?|[HLR]?豆つぶ|((?<!クス)H|[FL])?粉剤(DL)?|S?油剤[CD]?|MC$|ジェット$|ベイト$|(?<!トス)パック$)', tsusho, '');
drop table if exists tTpl2;
create temp table tTpl2 as select ippanmei, seibun,
  max([#sakumotsu#]) as [#sakumotsu#],
tsusho, rac from tTpl1 group by ippanmei, tsusho;
drop table tTpl1;
create temp table tTpl1 as select ippanmei, concat(',',tsusho||rac) as tsusho
from tTpl2 where
  [#sakumotsu#] and
1 group by ippanmei;
drop table tTpl2;
select mid as FRACコード,
  sayokiko, sayoten, fgroup as FRAC系統, keito, risk, ippanmei, tsusho from frac_ai left join frac_sg using(sid) left join frac_mg using(mid)
--sayokiko, sayoten, keito, ippanmei, tsusho from irac_ai left join irac_sg using(sid) left join irac_mg using(mid)
--lhrac as 旧分類, sayokiko, sayoten, keito, ippanmei, tsusho from hrac_ai left join hrac_sg using(sid) left join hrac_mg using(mid)
left join tTpl1 using(ippanmei) where tsusho is not null;
}
</xmp></dd>
<dt>デフォルト定義</dt>
<dd><pre>
#default {
}
</pre></dd>
</dl>
</body>
</html>
