function basecbox(col) {
  var cbox =
  '<ul>'+
  '<li>都道府県別流通状況<select name="SP" onChange="SelPref()">'+
  '<option value="zenkoku">全国'+
  '<option value="hokkaido">北海道'+
  '<option value="aomori">青森県'+
  '<option value="iwate">岩手県'+
  '<option value="miyagi">宮城県'+
  '<option value="akita">秋田県'+
  '<option value="yamagata">山形県'+
  '<option value="fukushima">福島県'+
  '<option value="ibaraki">茨城県'+
  '<option value="tochigi">栃木県'+
  '<option value="gunma">群馬県'+
  '<option value="saitama">埼玉県'+
  '<option value="chiba">千葉県'+
  '<option value="tokyo">東京都'+
  '<option value="kanagawa">神奈川県'+
  '<option value="yamanashi">山梨県'+
  '<option value="nagano">長野県'+
  '<option value="shizuoka">静岡県'+
  '<option value="niigata">新潟県'+
  '<option value="toyama">冨山県'+
  '<option value="ishikawa">石川県'+
  '<option value="fukui">福井県'+
  '<option value="gifu">岐阜県'+
  '<option value="aichi">愛知県'+
  '<option value="mie">三重県'+
  '<option value="shiga">滋賀県'+
  '<option value="kyoto">京都府'+
  '<option value="osaka">大阪府'+
  '<option value="hyogo">兵庫県'+
  '<option value="nara">奈良県'+
  '<option value="wakayama">和歌山県'+
  '<option value="tottori">鳥取県'+
  '<option value="shimane">島根県'+
  '<option value="okayama">岡山県'+
  '<option value="hiroshima">広島県'+
  '<option value="yamaguchi">山口県'+
  '<option value="tokushima">徳島県'+
  '<option value="kagawa">香川県'+
  '<option value="ehime">愛媛県'+
  '<option value="kochi">高知県'+
  '<option value="fukuoka">福岡県'+
  '<option value="saga">佐賀県'+
  '<option value="nagasaki">長崎県'+
  '<option value="kumamoto">熊本県'+
  '<option value="oita">大分県'+
  '<option value="miyazaki">宮崎県'+
  '<option value="kagoshima">鹿児島県'+
  '<option value="okinawa">沖縄県'+
  '</select><div class="balloon">'+
  '<p>都道府県を選択すると、各剤のその都道府県での流通の有無(-2:統計データ無、-1:全国流通無、0:無、1:有)が表示されます。'+
  '流通の集計期間は、SQLタブで「流通年度.qry」を読み込んで実行した際に表示される農薬年度になります。'+
  'たとえば、"2014" と表示された場合は 2014 農薬年度(2013.10.1～2014.9.30)の集計結果になります。</p>'+
  '<p>登録年月日が古いのに全国流通がない剤は、製造中止などで登録は残っていても実際には流通していない可能性が高いと判断できます。</p>'+
  '<span class="arrow"><span class="inarrow"></span></span>'+
  "</div></li>\r\n"+
  '<li>混合剤出力形式<select name="ST" onChange="SelType()">'+
  '<option value="tcol">列分割'+
  '<option value="trow">行分割'+
  '<option value="tclb">セル内改行'+
  '</select><div class="balloon">'+
  '<p>「行分割」「セル内改行」を選択すると、ACFinder 内では有効成分～'+col+'はセル内で改行された状態で表示されます。'+
  'Excel 等表計算ソフトに転送すると、「行分割」では有効成分毎に異なる行に分割され、「セル内改行」では ACFinder の表示結果と同様にセル内改行されます。</p>'+
  '<span class="arrow"><span class="inarrow"></span></span>'+
  "</div></li>\r\n";
  return cbox;
}

function tooltip(tips) {
  var body = document.body;
  for(var key in tips) {
    body.innerHTML = body.innerHTML.replace(new RegExp('(' +key + ')', 'g'), '<span class="tip" title="'+tips[key]+'">$1</span>');
  }
}

const stdtips = {
  '細作物群':"「とうがらし類」「なばな類」など「農薬の適用病害虫の範囲及び使用方法に係る適用農作物等の名称について」に記載がないか作物名として記載されているが、農水省検索システムでは小作物群と作物名の間に位置する作物群として扱われている作物名",
  '詳細作物名':"「りんご(ふじ)」などの品種名や「きゅうり(施設栽培)」などの栽培条件が括弧書きで付記された作物名",
  '作物系統':"目的とする作物名(栽培条件等を限定する場合は詳細作物名)やその上位作物群名を「'トマト(施設栽培),トマト,なす科果菜類,野菜類'」のようにカンマ(,)区切りで列挙してシングルクォート(')で括ったもの"
};

function init(col, opt1, opt2) {
  tooltip(stdtips);
  pref = 'zenkoku';
  document.getElementById('tcol').style.display = 'block';
  document.getElementById('trow').style.display = 'none';
  document.getElementById('tclb').style.display = 'none';
  if (!col) col = 'RACコード';
  var cbox = basecbox(col);
  if (opt1) cbox = cbox + opt1;
  if (opt2) cbox = cbox + opt2;
  document.getElementById('cbox').innerHTML = cbox;
}

function SelPref() {
  var n = document.F1.SP.selectedIndex;
  var newpref = document.F1.SP.options[n].value;
  var node = document.getElementById('sql');
  node.firstChild.nodeValue = node.firstChild.nodeValue.replace(pref + ' as ryutsu', newpref + ' as ryutsu');
  if (pref == 'zenkoku' || pref == 'hokkaido') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(" --ryakusho <> 'ホクサン株式会社'", " ryakusho <> 'ホクサン株式会社'");
  }
  if (pref == 'zenkoku' || pref == 'okinawa') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(" --ryakusho <> '琉球産経株式会社'", " ryakusho <> '琉球産経株式会社'");
  }
  if (newpref == 'zenkoku' || newpref == 'hokkaido') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(" ryakusho <> 'ホクサン株式会社'", " --ryakusho <> 'ホクサン株式会社'");
  }
  if (newpref == 'zenkoku' || newpref == 'okinawa') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(" ryakusho <> '琉球産経株式会社'", " --ryakusho <> '琉球産経株式会社'");
  }
  pref = newpref;
}

function SelType() {
  var n = document.F1.ST.selectedIndex;
  var otyp = document.F1.ST.options[n].value;
  var node = document.getElementById('sql');
  var tcol = document.getElementById('tcol');
  var trow = document.getElementById('trow');
  if (otyp == 'tcol') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/ --seibun([1-5]),(kaisu|keito)\1,/g, " seibun$1,$2$1,");
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/ concat2\(x'1d0d',/g, " --concat2(x'1d0d',");
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/ concat2\(x'1f0d',/g, " --concat2(x'1f0d',");
    tcol.style.display = 'block';
    trow.style.display = 'none';
    tclb.style.display = 'none';
  } else if (otyp == 'trow') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/ seibun([1-5]),(kaisu|keito)\1,/g, " --seibun$1,$2$1,");
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/ --concat2\(x'1d0d',/g, " concat2(x'1d0d',");
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/ concat2\(x'1f0d',/g, " --concat2(x'1f0d',");
    tcol.style.display = 'none';
    trow.style.display = 'block';
    tclb.style.display = 'none';
  } else {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/ seibun([1-5]),(kaisu|keito)\1,/g, " --seibun$1,$2$1,");
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/ concat2\(x'1d0d',/g, " --concat2(x'1d0d',");
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/ --concat2\(x'1f0d',/g, " concat2(x'1f0d',");
    tcol.style.display = 'none';
    trow.style.display = 'none';
    tclb.style.display = 'block';
  }
}

function autodep() {
  var cbox =
  '<li>作物群一括検索<select name="SD" onChange="SelDeploy()">'+
  '<option value="auto">する'+
  '<option value="none">しない'+
  '</select><div class="balloon">'+
  '<p>「する」を選択すると、作物名ボックスに「きゅうり」のように作物名のみを指定するだけで、上位作物群も検索対象とします。'+
  "「'きゅうり,うり類(未成熟),うり科野菜類,うり類'」のように作物系統を指定した場合でも、先頭に指定した作物(群)名から自動的に大作物群まで検索します。</p>"+
  '<p>大作物群は検索対象から外すなど、検索対象作物群を限定したい場合は、「しない」を選択して必要な作物系統を作物名ボックスに設定してください。</p>'+
  '<span class="arrow"><span class="inarrow"></span></span>'+
  "</div></li>\r\n";
/*
  cbox = cbox +
  '<li>複数作物検索タイプ<select name="SST" onChange="SelSearchType()">'+
  '<option value="or">OR'+
  '<option value="and">AND'+
  '</select><div class="balloon">'+
  "<p>作物名ボックスに「'ししとう','甘長とうがらし'」のように複数の作物系列を指定した場合の、検索方法を指定します。"+
  '「OR」を選択した場合は指定した作物系列のいずれにか登録のある農薬、「AND」を指定した場合は指定した作物系列に共通して登録のある農薬を検索します。</p>'+
  '<p>指定した作物系列がひとつだけの場合は、どちらでも結果は同じです。</p>'+
  '<span class="arrow"><span class="inarrow"></span></span>'+
  "</div></li>\r\n";
*/
  return cbox;
}

function SelDeploy() {
  var n = document.F1.SD.selectedIndex;
  var ctyp = document.F1.SD.options[n].value;
  var node = document.getElementById('sql');
  if (ctyp == 'auto') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/:(sakumotsu):/mig, "~$1~");
  } else {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/~(sakumotsu)~/mig, ":$1:");
  }
/*
  if (ctyp == 'auto') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/^((\/\*)?autodeploy)/mg, "--$1");
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/^--((\/\*)?nodeploy)/mg, "$1");
  } else {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/^((\/\*)?nodeploy)/mg, "--$1");
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/^--((\/\*)?autodeploy)/mg, "$1");
  }
*/
}

/*
function SelSearchType() {
  var n = document.F1.SST.selectedIndex;
  var styp = document.F1.SST.options[n].value;
  var node = document.getElementById('sql');
  if (styp == 'and') {
  } else {
  }
}
*/

function ExcSprd() {
  var cbox =
  '<li>展着剤等除外<select name="O1" onChange="SelSprd()">'+
  '<option value="exclude">する'+
  '<option value="include">しない'+
  '</select><div class="balloon">'+
  '<p>「する」を選択すると、展着剤や倉庫くん蒸剤を検索対象から除外します。</p>'+
  '<span class="arrow"><span class="inarrow"></span></span>'+
  "</div></li>\r\n";
  return cbox;
}

function SelSprd() {
  var n = document.F1.O1.selectedIndex;
  var ctyp = document.F1.O1.options[n].value;
  var node = document.getElementById('sql');
  if (ctyp == 'include') {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/(\(shurui \<\> '展着剤')/, "--$1");
  } else {
    node.firstChild.nodeValue = node.firstChild.nodeValue.replace(/--(\(shurui \<\> '展着剤')/, "$1");
  }
}
